/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.java;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.function.Supplier;
import org.dellroad.stuff.java.ThreadLocalHolder;

public class IdGenerator {
    private static final ThreadLocalHolder<IdGenerator> CURRENT = new ThreadLocalHolder();
    private final HashMap<Ref, Long> idMap = new HashMap();
    private final HashMap<Long, Ref> refMap = new HashMap();
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private long next = 1L;

    public synchronized long getId(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("null obj");
        }
        this.flush();
        Long id = this.idMap.get(new Ref(obj));
        if (id == null) {
            if (this.next == 0L) {
                throw new IllegalStateException("no more identifiers left!");
            }
            Ref ref = new Ref(obj, this.queue);
            id = this.next++;
            this.idMap.put(ref, id);
            this.refMap.put(id, ref);
        }
        return id;
    }

    public synchronized long nextId() {
        return this.next;
    }

    public synchronized long checkId(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("null obj");
        }
        this.flush();
        Long id = this.idMap.get(new Ref(obj));
        return id != null ? id : 0L;
    }

    public synchronized void setId(Object obj, long id) {
        if (obj == null) {
            throw new IllegalArgumentException("null obj");
        }
        this.flush();
        Ref ref = this.refMap.get(id);
        if (ref != null) {
            if (ref.get() != obj) {
                throw new IllegalArgumentException("id " + id + " is already assigned to another object");
            }
            return;
        }
        ref = new Ref(obj, this.queue);
        this.idMap.put(ref, id);
        this.refMap.put(id, ref);
    }

    public synchronized Object getObject(long id) {
        this.flush();
        Ref ref = this.refMap.get(id);
        return ref != null ? ref.get() : null;
    }

    public synchronized void flush() {
        Reference<Object> entry;
        while ((entry = this.queue.poll()) != null) {
            Ref ref = (Ref)entry;
            Long id = this.idMap.get(ref);
            this.idMap.remove(ref);
            this.refMap.remove(id);
        }
    }

    public static void run(Runnable action) {
        IdGenerator current = CURRENT.get();
        if (current == null) {
            current = new IdGenerator();
        }
        CURRENT.invoke(current, action);
    }

    public static <R> R run(Supplier<R> action) {
        IdGenerator current = CURRENT.get();
        if (current == null) {
            current = new IdGenerator();
        }
        return CURRENT.invoke(current, action);
    }

    public static IdGenerator get() {
        return CURRENT.require();
    }

    private static final class Ref
    extends WeakReference<Object> {
        private final int hashCode;

        Ref(Object obj, ReferenceQueue<Object> queue) {
            super(obj, queue);
            if (obj == null) {
                throw new IllegalArgumentException("null obj");
            }
            this.hashCode = System.identityHashCode(obj);
        }

        Ref(Object obj) {
            this(obj, (ReferenceQueue<Object>)null);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Ref that = (Ref)obj;
            obj = this.get();
            return obj != null ? obj == that.get() : false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

