/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.java;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.CodeSource;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MemoryClassLoader
extends URLClassLoader {
    public static final String MEMORY_URL_SCHEME = "memory";
    private final Map<String, ClassData> classDataMap = new HashMap<String, ClassData>();

    public MemoryClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public MemoryClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putClass(String className, byte[] classbytes) {
        if (className == null) {
            throw new IllegalArgumentException("null className");
        }
        MemoryClassLoader memoryClassLoader = this;
        synchronized (memoryClassLoader) {
            if (classbytes != null) {
                this.classDataMap.put(className, new ClassData((byte[])classbytes.clone()));
            } else {
                this.classDataMap.remove(className);
            }
        }
    }

    public synchronized byte[] getClass(String className) {
        return (byte[])this.classDataMap.get(className).getClassbytes().clone();
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        ClassData classData;
        MemoryClassLoader memoryClassLoader = this;
        synchronized (memoryClassLoader) {
            classData = this.classDataMap.get(className);
        }
        if (classData == null) {
            return super.findClass(className);
        }
        byte[] classbytes = classData.getClassbytes();
        return this.defineClass(className, classbytes, 0, classbytes.length, (CodeSource)null);
    }

    @Override
    public URL findResource(String resourceName) {
        URL resource = this.findClassDataResource(resourceName);
        if (resource != null) {
            return resource;
        }
        return super.findResource(resourceName);
    }

    @Override
    public Enumeration<URL> findResources(String resourceName) throws IOException {
        Enumeration<URL> resources = super.findResources(resourceName);
        URL classDataResource = this.findClassDataResource(resourceName);
        if (classDataResource != null) {
            ArrayList<URL> list = new ArrayList<URL>();
            while (resources.hasMoreElements()) {
                list.add(resources.nextElement());
            }
            list.add(classDataResource);
            resources = Collections.enumeration(list);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL findClassDataResource(String resourceName) {
        ClassData classData;
        if (resourceName == null) {
            throw new IllegalArgumentException("null resourceName");
        }
        if (!resourceName.endsWith(".class") || resourceName.startsWith("/")) {
            return null;
        }
        String className = resourceName.substring(0, resourceName.length() - 6).replace('/', '.');
        MemoryClassLoader memoryClassLoader = this;
        synchronized (memoryClassLoader) {
            classData = this.classDataMap.get(className);
        }
        if (classData == null) {
            return null;
        }
        try {
            URI memoryURI = new URI(MEMORY_URL_SCHEME, null, "/" + className, null);
            return new URL(null, memoryURI.toString(), new MemoryURLStreamHandler(classData));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("internal error", e);
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private static class MemoryURLConnection
    extends URLConnection {
        private static final String CONTENT_LENGTH_HEADER = "Content-Length";
        private static final String DATE_HEADER = "Date";
        private static final String LAST_MODIFIED_HEADER = "Last-Modified";
        private final InputStream in;
        private final String[][] fields;

        MemoryURLConnection(URL url, ClassData classData) {
            this(url, classData.getClassbytes(), classData.getCreateTime());
        }

        MemoryURLConnection(URL url, byte[] classbytes, long timestamp) {
            super(url);
            if (classbytes == null) {
                throw new IllegalArgumentException("null classbytes");
            }
            this.in = new ByteArrayInputStream(classbytes);
            Instant instant = Instant.ofEpochMilli(timestamp);
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.of("GMT"));
            String timestampString = DateTimeFormatter.RFC_1123_DATE_TIME.format(zonedDateTime);
            this.fields = new String[][]{{CONTENT_LENGTH_HEADER, "" + classbytes.length}, {DATE_HEADER, timestampString}, {LAST_MODIFIED_HEADER, timestampString}};
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() {
            return this.in;
        }

        @Override
        public String getHeaderField(String name) {
            return Stream.of(this.fields).filter(pair -> pair[0].equals(name)).map(pair -> pair[1]).findFirst().orElse(null);
        }

        @Override
        public Map<String, List<String>> getHeaderFields() {
            return Stream.of(this.fields).collect(Collectors.toMap(pair -> pair[0], pair -> Collections.singletonList(pair[1])));
        }

        @Override
        public String getHeaderFieldKey(int index) {
            return index < this.fields.length ? this.fields[index][0] : null;
        }

        @Override
        public String getHeaderField(int index) {
            return index < this.fields.length ? this.fields[index][1] : null;
        }
    }

    private static class MemoryURLStreamHandler
    extends URLStreamHandler {
        private final ClassData classData;

        MemoryURLStreamHandler(ClassData classData) {
            if (classData == null) {
                throw new IllegalArgumentException("null classData");
            }
            this.classData = classData;
        }

        @Override
        protected URLConnection openConnection(URL url) {
            return new MemoryURLConnection(url, this.classData.getClassbytes(), this.classData.getCreateTime());
        }
    }

    private static class ClassData {
        private final byte[] classbytes;
        private final long createTime = System.currentTimeMillis();

        ClassData(byte[] classbytes) {
            if (classbytes == null) {
                throw new IllegalArgumentException("null classbytes");
            }
            this.classbytes = classbytes;
        }

        public byte[] getClassbytes() {
            return this.classbytes;
        }

        public long getCreateTime() {
            return this.createTime;
        }
    }
}

