/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.java;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicLong;

public class ObjectComparator
implements Comparator<Object> {
    private final AtomicLong nextId = new AtomicLong();
    private final LoadingCache<Object, Long> idMap;

    public ObjectComparator() {
        this((CacheBuilder<Object, Object>)CacheBuilder.newBuilder());
    }

    public ObjectComparator(int concurrencyLevel) {
        this((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel));
    }

    protected ObjectComparator(CacheBuilder<Object, Object> cacheBuilder) {
        this.idMap = cacheBuilder.weakKeys().build((CacheLoader)new CacheLoader<Object, Long>(){

            public Long load(Object obj) {
                return ObjectComparator.this.nextId.getAndIncrement();
            }
        });
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        int hash2;
        if (obj1 == obj2) {
            return 0;
        }
        if (obj1 == null) {
            return 1;
        }
        if (obj2 == null) {
            return -1;
        }
        int hash1 = System.identityHashCode(obj1);
        if (hash1 < (hash2 = System.identityHashCode(obj2))) {
            return -1;
        }
        if (hash1 > hash2) {
            return 1;
        }
        long id1 = (Long)this.idMap.getUnchecked(obj1);
        long id2 = (Long)this.idMap.getUnchecked(obj2);
        assert (id1 != id2);
        return Long.compare(id1, id2);
    }
}

