/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.java;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dellroad.stuff.io.WriteCallback;

public class ProcessRunner {
    protected final Process process;
    private final WriteCallback inputWriter;
    private final ByteArrayOutputStream stdoutBuffer = new ByteArrayOutputStream();
    private final ByteArrayOutputStream stderrBuffer = new ByteArrayOutputStream();
    private int state;
    private boolean discardStandardOutput;
    private boolean discardStandardError;

    public ProcessRunner(Process process) {
        this(process, (WriteCallback)null);
    }

    public ProcessRunner(Process process, byte[] input) {
        this(process, output -> output.write(input));
    }

    public ProcessRunner(Process process, WriteCallback inputWriter) {
        if (process == null) {
            throw new IllegalArgumentException("null process");
        }
        this.process = process;
        this.inputWriter = inputWriter;
    }

    public Process getProcess() {
        return this.process;
    }

    public synchronized void setDiscardStandardOutput(boolean discardStandardOutput) {
        if (this.state != 0) {
            throw new IllegalStateException("run() has already been invoked");
        }
        this.discardStandardOutput = discardStandardOutput;
    }

    public synchronized void setDiscardStandardError(boolean discardStandardError) {
        if (this.state != 0) {
            throw new IllegalStateException("run() has already been invoked");
        }
        this.discardStandardError = discardStandardError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() throws InterruptedException {
        ProcessRunner processRunner = this;
        synchronized (processRunner) {
            if (this.state != 0) {
                throw new IllegalStateException("process has already been run");
            }
            this.state = 1;
        }
        IOThread<OutputStream> stdin = new IOThread<OutputStream>("stdin", (OutputStream)new BufferedOutputStream(this.process.getOutputStream())){

            @Override
            protected void runIO() throws IOException {
                if (ProcessRunner.this.inputWriter != null) {
                    ProcessRunner.this.inputWriter.writeTo((OutputStream)this.stream);
                }
            }
        };
        IOThread<InputStream> stdout = new IOThread<InputStream>("stdout", this.process.getInputStream()){

            @Override
            protected void runIO() throws IOException {
                int r;
                byte[] buf = new byte[1000];
                while ((r = ((InputStream)this.stream).read(buf)) != -1) {
                    ProcessRunner.this.handleStandardOutput(buf, 0, r);
                }
            }
        };
        IOThread<InputStream> stderr = new IOThread<InputStream>("stderr", this.process.getErrorStream()){

            @Override
            protected void runIO() throws IOException {
                int r;
                byte[] buf = new byte[1000];
                while ((r = ((InputStream)this.stream).read(buf)) != -1) {
                    ProcessRunner.this.handleStandardError(buf, 0, r);
                }
            }
        };
        stdin.start();
        stdout.start();
        stderr.start();
        Integer exitValue = null;
        try {
            exitValue = this.process.waitFor();
        }
        catch (InterruptedException e) {
            this.handleInterruption();
            throw e;
        }
        finally {
            ProcessRunner processRunner2 = this;
            synchronized (processRunner2) {
                this.state = 2;
            }
            if (exitValue == null) {
                stdin.close();
                stdout.close();
                stderr.close();
            }
            stdin.join();
            stdout.join();
            stderr.join();
        }
        assert (exitValue != null);
        return exitValue;
    }

    protected void handleInterruption() {
    }

    protected synchronized void handleStandardOutput(byte[] buf, int off, int len) {
        if (this.discardStandardOutput) {
            return;
        }
        this.stdoutBuffer.write(buf, off, len);
    }

    protected synchronized void handleStandardError(byte[] buf, int off, int len) {
        if (this.discardStandardError) {
            return;
        }
        this.stderrBuffer.write(buf, off, len);
    }

    public synchronized byte[] getStandardOutput() {
        if (this.state != 2) {
            throw new IllegalStateException("run() has not been invoked yet");
        }
        if (this.discardStandardOutput) {
            throw new IllegalStateException("this instance was configured to discard stdout");
        }
        return this.stdoutBuffer.toByteArray();
    }

    public synchronized byte[] getStandardError() {
        if (this.state != 2) {
            throw new IllegalStateException("run() has not been invoked yet");
        }
        if (this.discardStandardError) {
            throw new IllegalStateException("this instance was configured to discard stderr");
        }
        return this.stderrBuffer.toByteArray();
    }

    private static abstract class IOThread<T extends Closeable>
    extends Thread {
        protected final T stream;
        final /* synthetic */ ProcessRunner this$0;

        IOThread(String name, T stream) {
            this.this$0 = var1_1;
            super(name + " for " + var1_1.process);
            this.stream = stream;
        }

        @Override
        public final void run() {
            try {
                this.runIO();
            }
            catch (IOException iOException) {
            }
            finally {
                this.close();
            }
        }

        protected void close() {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected abstract void runIO() throws IOException;
    }
}

