/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.java;

import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static String propertyNameFromGetterMethod(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        if (method.getReturnType() == Void.TYPE || method.getParameterTypes().length != 0 || method.getName().startsWith("is") && method.getReturnType() != Boolean.TYPE) {
            return null;
        }
        return ReflectUtil.propertyNameFromGetterMethodName(method.getName());
    }

    public static String propertyNameFromGetterMethodName(String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("null methodName");
        }
        if (methodName.startsWith("get") && methodName.length() > 3) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        return null;
    }

    public static Map<String, List<Method>> findPropertySetters(Class<?> type, String methodPrefix) {
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        if (methodPrefix == null) {
            throw new IllegalArgumentException("null methodPrefix");
        }
        List<Method> methods = Arrays.asList(type.getMethods());
        HashMap<String, List<Method>> setterMap = new HashMap<String, List<Method>>();
        for (Method method : methods) {
            Class<?>[] parameterTypes;
            if (!method.getName().startsWith(methodPrefix) || method.getName().length() <= methodPrefix.length() || (parameterTypes = method.getParameterTypes()).length != 1) continue;
            String propertyName = Introspector.decapitalize(method.getName().substring(methodPrefix.length()));
            setterMap.computeIfAbsent(propertyName, n -> new ArrayList(3)).add(method);
        }
        setterMap.values().forEach(list -> ReflectUtil.sortByType(list, method -> method.getParameterTypes()[0]));
        return setterMap;
    }

    public static <T> T instantiate(Class<T> type) {
        Constructor<T> constructor;
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("cannot instantiate " + type + " because no zero-arg constructor could be found", e);
        }
        return ReflectUtil.instantiate(constructor, new Object[0]);
    }

    public static <T> T instantiate(Constructor<T> constructor, Object ... params) {
        if (constructor == null) {
            throw new IllegalArgumentException("null constructor");
        }
        if (params == null) {
            throw new IllegalArgumentException("null params");
        }
        try {
            constructor.setAccessible(true);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            return constructor.newInstance(params);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("cannot instantiate " + constructor.getDeclaringClass() + " using constructor " + constructor, e);
        }
    }

    public static Object invoke(Method method, Object target, Object ... params) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        if (params == null) {
            throw new IllegalArgumentException("null params");
        }
        try {
            return method.invoke(target, params);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sortByType(List<? extends Class<?>> list) {
        ReflectUtil.sortByType(list, Function.identity());
    }

    public static <T> void sortByType(List<T> list, Function<? super T, ? extends Class<?>> typer) {
        if (list == null) {
            throw new IllegalArgumentException("null list");
        }
        if (typer == null) {
            throw new IllegalArgumentException("null typer");
        }
        Comparator<T> comparator = Comparator.comparing(typer, ReflectUtil.getClassComparator());
        for (int targetIndex = 0; targetIndex < list.size() - 1; ++targetIndex) {
            T targetItem = list.get(targetIndex);
            int bestIndex = targetIndex;
            T bestItem = targetItem;
            for (int nextIndex = targetIndex + 1; nextIndex < list.size(); ++nextIndex) {
                T nextItem = list.get(nextIndex);
                if (comparator.compare(bestItem, nextItem) <= 0) continue;
                bestItem = nextItem;
                bestIndex = nextIndex;
            }
            list.set(targetIndex, bestItem);
            list.set(bestIndex, targetItem);
        }
    }

    public static Comparator<Class<?>> getClassComparator() {
        return ReflectUtil.getClassComparator(true);
    }

    public static Comparator<Class<?>> getClassComparator(boolean incomparableEqual) {
        return (type1, type2) -> {
            if (type1.isAssignableFrom((Class<?>)type2) && !type2.isAssignableFrom((Class<?>)type1)) {
                return 1;
            }
            if (!type1.isAssignableFrom((Class<?>)type2) && type2.isAssignableFrom((Class<?>)type1)) {
                return -1;
            }
            if (incomparableEqual) {
                return 0;
            }
            throw new IllegalArgumentException(type1 + " and " + type2 + " are incomparable");
        };
    }
}

