/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.java;

import java.util.ArrayList;

public final class SuperFinal {
    private static final ThreadLocal<ArrayList<Object>> STACK = new ThreadLocal();

    private SuperFinal() {
    }

    public static <P> P push(Object value, P param) {
        if (STACK.get() == null) {
            STACK.set(new ArrayList());
        }
        STACK.get().add(value);
        return param;
    }

    public static <V> V get(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("depth < 0");
        }
        ArrayList<Object> stack = STACK.get();
        if (stack == null) {
            throw new IllegalStateException("no stashed value at depth " + depth);
        }
        int stackSize = stack.size();
        if (depth >= stackSize) {
            throw new IllegalStateException("no stashed value at depth " + depth);
        }
        return (V)stack.get(stackSize - depth - 1);
    }

    public static <V> V get(V value) {
        return SuperFinal.get(0, value);
    }

    public static <V> V get(int depth, V value) {
        return value != null ? value : (V)SuperFinal.get(depth);
    }

    public static void pop() {
        ArrayList<Object> stack = STACK.get();
        if (stack == null || stack.isEmpty()) {
            throw new IllegalStateException("stack is empty");
        }
        int lastElementIndex = stack.size() - 1;
        stack.set(lastElementIndex, null);
        if (lastElementIndex > 0) {
            stack.remove(lastElementIndex);
        } else {
            STACK.remove();
        }
    }
}

