/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.java;

import java.util.function.Supplier;

public class ThreadLocalHolder<T> {
    private final ThreadLocal<T> threadLocal;

    public ThreadLocalHolder() {
        this(new ThreadLocal());
    }

    public ThreadLocalHolder(ThreadLocal<T> threadLocal) {
        if (threadLocal == null) {
            throw new IllegalArgumentException("null threadLocal");
        }
        this.threadLocal = threadLocal;
    }

    public void invoke(T value, Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException("null action");
        }
        this.invoke(value, () -> {
            action.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R invoke(T value, Supplier<R> action) {
        boolean topLevel;
        if (action == null) {
            throw new IllegalArgumentException("null action");
        }
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        T previousValue = this.threadLocal.get();
        boolean bl = topLevel = previousValue == null;
        if (!topLevel) {
            if (value != previousValue) {
                throw new IllegalStateException("already executing within an invocation of ThreadLocalHolder.invoke() but with a different value");
            }
        } else {
            this.threadLocal.set(value);
        }
        try {
            R r = action.get();
            return r;
        }
        finally {
            if (topLevel) {
                this.threadLocal.remove();
                this.destroy(value);
            }
        }
    }

    public T get() {
        return this.threadLocal.get();
    }

    public T require() {
        T value = this.threadLocal.get();
        if (value == null) {
            throw new IllegalStateException("no value associated with the current thread; are we executing within an invocation of ThreadLocalHolder.invoke()?");
        }
        return value;
    }

    protected void destroy(T value) {
    }
}

