/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.java;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.dellroad.stuff.java.TimedWait;

public class ThreadParkingLot {
    private final HashSet<Thread> parkedThreads = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean park(long timeout) throws InterruptedException {
        Thread thread = Thread.currentThread();
        this.parkedThreads.add(thread);
        try {
            boolean bl = TimedWait.wait(this, timeout, () -> !this.parkedThreads.contains(thread));
            return bl;
        }
        finally {
            this.parkedThreads.remove(thread);
        }
    }

    public synchronized boolean unpark(Thread thread) {
        boolean wasParked = this.parkedThreads.remove(thread);
        if (wasParked) {
            this.notifyAll();
        }
        return wasParked;
    }

    public synchronized boolean isParked(Thread thread) {
        return this.parkedThreads.contains(thread);
    }

    public synchronized Set<Thread> getParkedThreads() {
        return Collections.unmodifiableSet(new HashSet<Thread>(this.parkedThreads));
    }
}

