/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.main;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import jline.console.ConsoleReader;
import jline.console.UserInterruptException;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MainClass {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ConsoleReader console;

    protected MainClass() {
    }

    public abstract int run(String[] var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commandLoop(String appName, String prompt) throws Exception {
        FileHistory history;
        this.console = new ConsoleReader(appName, System.in, (OutputStream)System.out, null, null);
        this.console.setBellEnabled(true);
        this.console.setHistoryEnabled(true);
        this.console.setHandleUserInterrupt(true);
        File historyFile = new File(new File(System.getProperty("user.home")), "." + appName + "_history");
        try {
            history = new FileHistory(historyFile);
        }
        catch (IOException e) {
            history = null;
        }
        this.console.setHistory((History)history);
        try {
            while (true) {
                String line;
                try {
                    line = this.console.readLine(prompt);
                }
                catch (UserInterruptException e) {
                    this.console.print((CharSequence)"^C");
                    line = null;
                }
                if (line == null) {
                    this.console.println();
                    break;
                }
                if (!this.handleCommand(line)) {
                    break;
                }
                this.console.flush();
            }
        }
        finally {
            if (history != null) {
                history.flush();
            }
            this.console.flush();
            this.console.close();
        }
    }

    protected boolean handleCommand(String line) throws Exception {
        return false;
    }

    protected abstract void usageMessage();

    protected void usageError() {
        this.usageMessage();
        System.exit(1);
    }

    protected final void errout(String message) {
        System.err.println(this.getClass().getSimpleName() + ": " + message);
        System.exit(1);
    }

    protected String[] parsePropertyFlags(String[] args) {
        ArrayList<String> list = new ArrayList<String>(args.length);
        boolean done = false;
        for (String arg : args) {
            if (done) {
                list.add(arg);
                continue;
            }
            if (arg.equals("--") || arg.length() == 0 || arg.charAt(0) != '-') {
                list.add(arg);
                done = true;
                continue;
            }
            if (arg.startsWith("-D")) {
                int eq = arg.indexOf(61);
                if (eq < 3) {
                    this.usageError();
                }
                System.setProperty(arg.substring(2, eq), arg.substring(eq + 1));
                continue;
            }
            list.add(arg);
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMain(String[] args) {
        int exitValue = 1;
        try {
            exitValue = this.run(args);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            System.exit(exitValue);
        }
    }
}

