/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.net;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.dellroad.stuff.net.ChannelConnection;
import org.dellroad.stuff.net.Network;
import org.dellroad.stuff.net.SelectorSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelNetwork
extends SelectorSupport
implements Network {
    public static final int DEFAULT_MAX_CONNECTIONS = 1000;
    public static final long DEFAULT_MAX_IDLE_TIME = 30000L;
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 0x2000000;
    public static final long DEFAULT_MAX_OUTPUT_QUEUE_SIZE = 0x4000000L;
    public static final long DEFAULT_MAX_INPUT_QUEUE_SIZE = 0x8000000L;
    public static final int DEFAULT_MIN_DIRECT_BUFFER_SIZE = 65536;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final HashMap<String, ChannelConnection> connectionMap = new HashMap();
    private int maxConnections = 1000;
    private long maxIdleTime = 30000L;
    private int maxMessageSize = 0x2000000;
    private long maxOutputQueueSize = 0x4000000L;
    private long maxInputQueueSize = 0x8000000L;
    private int minDirectBufferSize = 65536;
    private HandlerThread handlerThread;
    private String serviceThreadName;

    public synchronized int getMaxConnections() {
        return this.maxConnections;
    }

    public synchronized void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public synchronized long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public synchronized void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public synchronized int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public synchronized void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public synchronized long getMaxOutputQueueSize() {
        return this.maxOutputQueueSize;
    }

    public synchronized void setMaxOutputQueueSize(long maxOutputQueueSize) {
        this.maxOutputQueueSize = maxOutputQueueSize;
        for (ChannelConnection connection : this.connectionMap.values()) {
            connection.updateSelection();
        }
    }

    public synchronized long getMaxInputQueueSize() {
        return this.maxInputQueueSize;
    }

    public synchronized void setMaxInputQueueSize(long maxInputQueueSize) {
        this.maxInputQueueSize = maxInputQueueSize;
        for (ChannelConnection connection : this.connectionMap.values()) {
            connection.updateSelection();
        }
    }

    public synchronized String getServiceThreadName() {
        return this.serviceThreadName;
    }

    public synchronized void setServiceThreadName(String serviceThreadName) {
        this.serviceThreadName = serviceThreadName;
    }

    public synchronized int getMinDirectBufferSize() {
        return this.minDirectBufferSize;
    }

    public synchronized void setMinDirectBufferSize(int minDirectBufferSize) {
        this.minDirectBufferSize = minDirectBufferSize;
    }

    @Override
    public synchronized void start(Network.Handler handler) throws IOException {
        super.start();
        boolean successful = false;
        try {
            if (this.handlerThread != null) {
                return;
            }
            this.handlerThread = new HandlerThread(handler);
            if (this.log.isDebugEnabled()) {
                this.log.debug("starting " + this);
            }
            if (this.serviceThreadName != null) {
                this.handlerThread.setName(this.serviceThreadName);
            }
            this.handlerThread.start();
            successful = true;
        }
        finally {
            if (!successful) {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        super.stop();
        ChannelNetwork channelNetwork = this;
        synchronized (channelNetwork) {
            if (this.handlerThread == null) {
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("stopping " + this);
            }
            this.handlerThread = null;
            this.notifyAll();
        }
    }

    @Override
    public synchronized boolean send(String peer, ByteBuffer msg) {
        if (peer == null) {
            throw new IllegalArgumentException("null peer");
        }
        String normalizedPeer = this.normalizePeerName(peer);
        ChannelConnection connection = this.connectionMap.get(normalizedPeer);
        if (connection == null) {
            try {
                connection = this.createConnection(peer);
            }
            catch (IOException e) {
                this.log.info(this + " unable to send message to `" + peer + "': " + e.getMessage());
                return false;
            }
            this.connectionMap.put(normalizedPeer, connection);
        }
        return connection.output(msg);
    }

    void handleConnectionClosed(ChannelConnection connection) {
        assert (Thread.holdsLock(this));
        assert (this.isServiceThread());
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + " handling closed connection " + connection);
        }
        String normalizedPeer = this.normalizePeerName(connection.getPeer());
        this.connectionMap.remove(normalizedPeer);
        this.wakeup();
    }

    protected String normalizePeerName(String peer) {
        return peer;
    }

    protected abstract ChannelConnection createConnection(String var1) throws IOException;

    @Override
    protected void serviceHousekeeping() {
        for (ChannelConnection connection : new ArrayList<ChannelConnection>(this.connectionMap.values())) {
            try {
                connection.performHousekeeping();
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("I/O error from " + connection, (Throwable)e);
                }
                connection.close(e);
            }
            catch (Throwable t) {
                this.log.error("error performing housekeeping for " + connection, t);
                connection.close(t);
            }
        }
    }

    @Override
    protected void serviceCleanup() {
        for (ChannelConnection connection : new ArrayList<ChannelConnection>(this.connectionMap.values())) {
            connection.close(null);
        }
    }

    private class HandlerThread
    extends Thread {
        private final Logger log;
        private final Network.Handler handler;

        HandlerThread(Network.Handler handler) {
            this.log = ChannelNetwork.this.log;
            Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (Object)"null handler");
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int counter = 0;
                while (true) {
                    ByteBuffer buf = null;
                    String peer = null;
                    boolean outputQueueEmpty = false;
                    ChannelNetwork channelNetwork = ChannelNetwork.this;
                    synchronized (channelNetwork) {
                        ChannelConnection connection;
                        block11: while (true) {
                            if (ChannelNetwork.this.handlerThread != this) {
                                return;
                            }
                            ChannelConnection[] connections = ChannelNetwork.this.connectionMap.values().toArray(new ChannelConnection[0]);
                            for (int i = 0; i < connections.length; ++i) {
                                connection = connections[counter++ % connections.length];
                                counter &= Integer.MAX_VALUE;
                                outputQueueEmpty = connection.pollForOutputQueueEmpty();
                                buf = connection.pollForInputQueueNotEmpty();
                                if (outputQueueEmpty || buf != null) break block11;
                            }
                            ChannelNetwork.this.wait();
                        }
                        peer = connection.getPeer();
                    }
                    if (outputQueueEmpty) {
                        try {
                            this.handler.outputQueueEmpty(peer);
                        }
                        catch (Throwable t) {
                            this.log.error("exception in callback", t);
                        }
                    }
                    if (buf == null) continue;
                    try {
                        this.handler.handle(peer, buf);
                    }
                    catch (Throwable t) {
                        this.log.error("exception in callback", t);
                    }
                }
            }
            catch (Error | RuntimeException t) {
                this.log.error("unexpected exception in HandlerThread", t);
                throw t;
            }
            catch (Throwable t) {
                this.log.error("unexpected exception in HandlerThread", t);
                throw new RuntimeException(t);
            }
        }
    }
}

