/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.net;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IPv4Util {
    public static final int MIN_VALID_NETMASK_WIDTH = 8;
    public static final int MAX_VALID_NETMASK_WIDTH = 30;

    private IPv4Util() {
    }

    public static Inet4Address toAddress(int address) {
        return IPv4Util.toAddress(new byte[]{(byte)(address >> 24 & 0xFF), (byte)(address >> 16 & 0xFF), (byte)(address >> 8 & 0xFF), (byte)(address & 0xFF)});
    }

    public static int toInt32(Inet4Address address) {
        byte[] bytes = address.getAddress();
        return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    public static long toUInt32(Inet4Address address) {
        return (long)IPv4Util.toInt32(address) & 0xFFFFFFFFL;
    }

    public static Inet4Address toAddress(byte[] bytes) {
        if (bytes.length != 4) {
            throw new IllegalArgumentException("array has length " + bytes.length + " != 4");
        }
        try {
            return (Inet4Address)InetAddress.getByAddress(IPv4Util.toString(bytes), bytes);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("unexpected exception", e);
        }
    }

    public static String toString(Inet4Address address) {
        return IPv4Util.toString(address.getAddress());
    }

    public static String toString(Inet4Address address, Inet4Address netmask) {
        return IPv4Util.toString(address) + "/" + IPv4Util.getWidth(netmask);
    }

    private static String toString(byte[] bytes) {
        assert (bytes.length == 4);
        return (bytes[0] & 0xFF) + "." + (bytes[1] & 0xFF) + "." + (bytes[2] & 0xFF) + "." + (bytes[3] & 0xFF);
    }

    public static Inet4Address fromString(String string) {
        String bytepat = "([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])";
        Pattern pattern = Pattern.compile(bytepat + "\\." + bytepat + "\\." + bytepat + "\\." + bytepat);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("invalid IP address: " + string);
        }
        return IPv4Util.toAddress(new byte[]{(byte)Integer.parseInt(matcher.group(1)), (byte)Integer.parseInt(matcher.group(2)), (byte)Integer.parseInt(matcher.group(3)), (byte)Integer.parseInt(matcher.group(4))});
    }

    public static int getWidth(Inet4Address netmask) {
        int mask = IPv4Util.toInt32(netmask);
        if (mask == 0) {
            return 0;
        }
        for (int shift = 0; shift < 32; ++shift) {
            if (mask != -1 << shift) continue;
            return 32 - shift;
        }
        throw new IllegalArgumentException("invalid netmask " + netmask);
    }

    public static boolean isValidNetmask(Inet4Address netmask) {
        try {
            int width = IPv4Util.getWidth(netmask);
            return width >= 8 && width <= 30;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Inet4Address getNetmaskForWidth(int width) {
        if (width < 0 || width > 32) {
            throw new IllegalArgumentException("invalid netmask width " + width);
        }
        return IPv4Util.toAddress(-1 << 32 - width);
    }

    public static Inet4Address getBaseAddress(Inet4Address address, Inet4Address netmask) {
        int addr = IPv4Util.toInt32(address);
        int width = IPv4Util.getWidth(netmask);
        return IPv4Util.toAddress(addr &= -1 << 32 - width);
    }

    public static Inet4Address getBroadcastAddress(Inet4Address address, Inet4Address netmask) {
        int addr = IPv4Util.toInt32(address);
        int width = IPv4Util.getWidth(netmask);
        return IPv4Util.toAddress(addr |= ~(-1 << 32 - width));
    }

    public static boolean isOnNetwork(Inet4Address address, Inet4Address network, Inet4Address netmask) {
        int addr1 = IPv4Util.toInt32(address);
        int addr2 = IPv4Util.toInt32(network);
        int width = IPv4Util.getWidth(netmask);
        int mask = -1 << 32 - width;
        return (addr1 & mask) == (addr2 & mask);
    }

    public static boolean isValidHostOnNetwork(Inet4Address address, Inet4Address network, Inet4Address netmask) {
        return IPv4Util.isOnNetwork(address, network, netmask) && !address.equals(IPv4Util.getBaseAddress(network, netmask)) && !address.equals(IPv4Util.getBroadcastAddress(network, netmask));
    }
}

