/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.net;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistentConnection<C> {
    public static final long DEFAULT_MIN_RESTART_DELAY = 10000L;
    public static final long DEFAULT_MAX_RESTART_DELAY = 600000L;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private long minRestartDelay = 10000L;
    private long maxRestartDelay = 600000L;
    private volatile ClientThread thread;

    public void setMinRestartDelay(long minRestartDelay) {
        this.minRestartDelay = minRestartDelay;
    }

    public long getMinRestartDelay() {
        return this.minRestartDelay;
    }

    public void setMaxRestartDelay(long maxRestartDelay) {
        this.maxRestartDelay = maxRestartDelay;
    }

    public long getMaxRestartDelay() {
        return this.maxRestartDelay;
    }

    protected String getThreadName() {
        return this + " thread";
    }

    @PostConstruct
    public synchronized void start() {
        if (this.thread != null) {
            return;
        }
        this.thread = new ClientThread();
        this.thread.start();
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.thread != null) {
            this.log.info("stopping " + this + " thread " + this.thread);
            this.thread.interrupt();
            this.thread = null;
        }
    }

    public final synchronized boolean isRunning() {
        return this.thread != null;
    }

    private void poll() {
        long restartDelay = this.minRestartDelay;
        while (this.thread == Thread.currentThread()) {
            if (this.doConnection()) {
                restartDelay = this.minRestartDelay;
            }
            if (this.thread != Thread.currentThread()) {
                this.log.info(this + " thread exiting");
                break;
            }
            try {
                this.log.info(this + " pausing " + restartDelay + "ms before next connection attempt");
                Thread.sleep(restartDelay);
            }
            catch (InterruptedException e) {
                this.log.info(this + " thread exiting due to interrupt");
                break;
            }
            restartDelay = Math.max(this.minRestartDelay, Math.min(restartDelay * 2L, this.maxRestartDelay));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doConnection() {
        ClientThread thisClientThread = (ClientThread)Thread.currentThread();
        try {
            thisClientThread.createConnection();
        }
        catch (Exception e) {
            this.connectionFailed(e);
            return false;
        }
        this.connectionSuccessful();
        try {
            if (this.thread != Thread.currentThread()) {
                boolean e = true;
                return e;
            }
            Exception exception = null;
            try {
                thisClientThread.handleConnection();
            }
            catch (Exception e) {
                exception = e;
            }
            this.connectionEnded(exception);
            boolean bl = true;
            return bl;
        }
        finally {
            thisClientThread.cleanupConnection();
        }
    }

    protected abstract C createConnection() throws InterruptedException, IOException;

    protected abstract void handleConnection(C var1) throws InterruptedException, IOException;

    protected void cleanupConnection(C connectionContext) {
    }

    protected void started() {
    }

    protected void stopped(Throwable t) {
    }

    protected void connectionSuccessful() {
    }

    protected void connectionFailed(Exception e) {
    }

    protected void connectionEnded(Exception e) {
    }

    private class ClientThread
    extends Thread {
        private volatile C context;

        ClientThread() {
            super(PersistentConnection.this.getThreadName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable exception = null;
            try {
                PersistentConnection.this.log.info(PersistentConnection.this + " thread starting");
                PersistentConnection.this.started();
                PersistentConnection.this.poll();
            }
            catch (Throwable t) {
                exception = t;
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException(t);
            }
            finally {
                PersistentConnection persistentConnection = PersistentConnection.this;
                synchronized (persistentConnection) {
                    if (PersistentConnection.this.thread == this) {
                        PersistentConnection.this.thread = null;
                    }
                }
                PersistentConnection.this.stopped(exception);
            }
        }

        void createConnection() throws Exception {
            this.context = PersistentConnection.this.createConnection();
        }

        void handleConnection() throws Exception {
            PersistentConnection.this.handleConnection(this.context);
        }

        void cleanupConnection() {
            PersistentConnection.this.cleanupConnection(this.context);
        }
    }
}

