/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.net;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import org.dellroad.stuff.net.PersistentConnection;

public abstract class PersistentSocketConnection
extends PersistentConnection<Socket> {
    private SocketAddress serverAddress;

    public SocketAddress getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(SocketAddress serverAddress) {
        this.serverAddress = serverAddress;
    }

    @Override
    public void start() {
        if (this.serverAddress == null) {
            throw new IllegalArgumentException("no serverAddress configured");
        }
        super.start();
    }

    @Override
    protected Socket createConnection() throws InterruptedException, IOException {
        Socket socket = this.createSocket();
        socket.connect(this.serverAddress);
        return socket;
    }

    @Override
    protected void cleanupConnection(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Socket createSocket() throws IOException {
        Socket socket = new Socket();
        socket.setKeepAlive(true);
        return socket;
    }
}

