/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.net;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.dellroad.stuff.net.ChannelConnection;
import org.dellroad.stuff.net.TCPNetwork;

public class TCPConnection
extends ChannelConnection {
    protected TCPConnection(TCPNetwork network, String peer, SocketChannel channel) throws IOException {
        super(network, peer, channel);
    }

    public SocketChannel getSocketChannel() {
        return (SocketChannel)this.getInputChannel();
    }

    @Override
    protected void updateSelection() {
        if (this.getSocketChannel().isConnectionPending()) {
            this.network.selectFor(this.inputSelectionKey, 8, true);
            this.network.selectFor(this.inputSelectionKey, 1, true);
            this.network.selectFor(this.outputSelectionKey, 4, false);
            return;
        }
        this.network.selectFor(this.inputSelectionKey, 8, false);
        super.updateSelection();
    }

    @Override
    public void serviceIO(SelectionKey key) throws IOException {
        assert (this.network.isServiceThread());
        assert (Thread.holdsLock(this.network));
        if (key.isConnectable()) {
            this.handleConnectable();
        }
        super.serviceIO(key);
    }

    private void handleConnectable() throws IOException {
        this.network.selectFor(this.inputSelectionKey, 8, false);
        if (!this.getSocketChannel().finishConnect()) {
            throw new IOException("connection failed");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(this + ": connection succeeded");
        }
        this.updateSelection();
        this.restartIdleTimer();
        this.handleOutputQueueEmpty();
    }

    @Override
    protected void performHousekeeping() throws IOException {
        assert (Thread.holdsLock(this.network));
        assert (this.network.isServiceThread());
        if (this.getSocketChannel().isConnectionPending()) {
            if (this.getIdleTime() >= ((TCPNetwork)this.network).getConnectTimeout()) {
                throw new IOException("connection unsuccessful after " + this.getIdleTime() + "ms");
            }
            return;
        }
        super.performHousekeeping();
    }
}

