/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.schema;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.dellroad.stuff.schema.UpdateInProgressException;

public abstract class AbstractUpdatingDataSource
implements DataSource {
    private static final int INITIAL = 0;
    private static final int UPDATING = 1;
    private static final int UPDATED = 2;
    private static final int FAILED = 3;
    private DataSource dataSource;
    private boolean asynchronous;
    private int state = 0;
    private SQLException error;
    private CompletableFuture<DataSource> future = new CompletableFuture<DataSource>(){

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            throw new UnsupportedOperationException("cancel() not supported");
        }
    };

    public synchronized void setDataSource(DataSource dataSource) {
        if (this.state != 0) {
            throw new IllegalStateException("update already triggered");
        }
        this.dataSource = dataSource;
    }

    public synchronized boolean isAsynchronous() {
        return this.asynchronous;
    }

    public synchronized void setAsynchronous(boolean asynchronous) {
        if (this.state != 0) {
            throw new IllegalStateException("update already triggered");
        }
        this.asynchronous = asynchronous;
    }

    protected abstract void updateDataSource(DataSource var1) throws SQLException;

    protected synchronized DataSource getInnerDataSource() {
        return this.dataSource;
    }

    public synchronized boolean isUpdated() {
        return this.state == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerUpdate() throws SQLException {
        boolean async;
        AbstractUpdatingDataSource abstractUpdatingDataSource = this;
        synchronized (abstractUpdatingDataSource) {
            async = this.asynchronous;
        }
        return this.triggerUpdate(async ? runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("SQL-Updater");
            thread.start();
        } : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean triggerUpdate(Executor executor) throws SQLException {
        AbstractUpdatingDataSource abstractUpdatingDataSource = this;
        synchronized (abstractUpdatingDataSource) {
            switch (this.state) {
                case 0: {
                    if (this.dataSource == null) {
                        throw new IllegalStateException("no DataSource configured");
                    }
                    this.state = 1;
                    if (!this.asynchronous) {
                        executor = r -> r.run();
                        break;
                    }
                    if (executor != null) break;
                    throw new IllegalArgumentException("null executor");
                }
                case 1: 
                case 2: {
                    return false;
                }
                case 3: {
                    throw new SQLException("update failed", this.error);
                }
                default: {
                    throw new RuntimeException("internal error: " + this.state);
                }
            }
        }
        executor.execute(this::doUpdate);
        return true;
    }

    public synchronized Future<DataSource> getUpdateCompleteFuture() {
        return this.future;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getUpdatedDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getUpdatedDataSource().getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getUpdatedDataSource().getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.getUpdatedDataSource().setLogWriter(pw);
    }

    @Override
    public void setLoginTimeout(int timeout) throws SQLException {
        this.getUpdatedDataSource().setLoginTimeout(timeout);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getUpdatedDataSource().getLoginTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> cl) throws SQLException {
        return cl.cast(this.getUpdatedDataSource());
    }

    @Override
    public boolean isWrapperFor(Class<?> cl) throws SQLException {
        return cl.isInstance(this.getUpdatedDataSource());
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        try {
            return this.getUpdatedDataSource().getParentLogger();
        }
        catch (SQLFeatureNotSupportedException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new SQLFeatureNotSupportedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource getUpdatedDataSource() throws SQLException {
        this.triggerUpdate();
        AbstractUpdatingDataSource abstractUpdatingDataSource = this;
        synchronized (abstractUpdatingDataSource) {
            if (this.asynchronous && this.state == 1) {
                throw new UpdateInProgressException("update still in progress");
            }
        }
        try {
            return this.getUpdateCompleteFuture().get();
        }
        catch (ExecutionException e) {
            throw new SQLException("DataSource update failed", e.getCause());
        }
        catch (InterruptedException e) {
            throw new SQLException("interrupted while waiting for update to complete", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate() {
        DataSource innerDataSource;
        AbstractUpdatingDataSource abstractUpdatingDataSource = this;
        synchronized (abstractUpdatingDataSource) {
            assert (this.state == 1);
            innerDataSource = this.dataSource;
        }
        try {
            this.updateDataSource(innerDataSource);
        }
        catch (Throwable t) {
            AbstractUpdatingDataSource abstractUpdatingDataSource2 = this;
            synchronized (abstractUpdatingDataSource2) {
                assert (this.state == 1);
                this.state = 3;
                this.future.completeExceptionally(t);
                this.error = t instanceof SQLException ? (SQLException)t : new SQLException(t);
                this.notifyAll();
            }
        }
        abstractUpdatingDataSource = this;
        synchronized (abstractUpdatingDataSource) {
            assert (this.state == 1);
            this.state = 2;
            this.future.complete(innerDataSource);
            this.notifyAll();
        }
    }
}

