/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.schema;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.dellroad.stuff.schema.DatabaseAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLCommand
implements DatabaseAction<Connection> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String sql;

    public SQLCommand(String sql) {
        if (sql == null) {
            throw new IllegalArgumentException("null sql");
        }
        if ((sql = sql.trim()).length() == 0) {
            throw new IllegalArgumentException("empty sql");
        }
        this.sql = sql;
    }

    public String getSQL() {
        return this.sql;
    }

    @Override
    public void apply(Connection c) throws SQLException {
        try (Statement statement = c.createStatement();){
            String sep = this.sql.indexOf(10) != -1 ? "\n" : " ";
            this.log.info("executing SQL statement:" + sep + this.sql);
            statement.execute(this.sql);
        }
    }
}

