/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.schema;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.dellroad.stuff.schema.AbstractUpdatingDataSource;
import org.dellroad.stuff.schema.SQLCommandList;

public class UpdatingDataSource
extends AbstractUpdatingDataSource {
    private SQLCommandList action;
    private boolean transactional = true;

    public void setSQLCommandList(SQLCommandList action) {
        this.action = action;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateDataSource(DataSource dataSource) throws SQLException {
        if (this.action == null) {
            throw new IllegalArgumentException("no SQLCommandList configured");
        }
        try (Connection c = dataSource.getConnection();){
            boolean tx = this.transactional;
            try {
                if (tx) {
                    c.setTransactionIsolation(8);
                    c.setAutoCommit(false);
                }
                this.action.apply(c);
                if (tx) {
                    c.commit();
                }
                tx = false;
            }
            finally {
                if (tx) {
                    c.rollback();
                }
            }
        }
    }
}

