/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.string;

public final class ByteArrayEncoder {
    private ByteArrayEncoder() {
    }

    public static String encode(byte[] array) {
        return ByteArrayEncoder.encode(array, 0, array.length);
    }

    public static String encode(byte[] array, int off, int len) {
        if (array == null) {
            return null;
        }
        if (off < 0 || len < 0 || off + len < 0 || off + len > array.length) {
            throw new IndexOutOfBoundsException("array bounds exceeded");
        }
        if (len > 0x3FFFFFFF) {
            throw new IllegalArgumentException("array is too long");
        }
        char[] buf = new char[len * 2];
        for (int i = 0; i < len; ++i) {
            int value = array[off + i] & 0xFF;
            buf[i * 2] = Character.forDigit(value >> 4, 16);
            buf[i * 2 + 1] = Character.forDigit(value & 0xF, 16);
        }
        return new String(buf);
    }

    public static byte[] decode(String text) {
        if (text == null) {
            return null;
        }
        byte[] array = new byte[text.length() / 2];
        int len = 0;
        boolean flipflop = false;
        int prevNibble = 0;
        int limit = text.length();
        for (int pos = 0; pos < limit; ++pos) {
            char ch = text.charAt(pos);
            if (Character.isWhitespace(ch)) continue;
            int nibble = Character.digit(ch, 16);
            if (nibble == -1) {
                throw new IllegalArgumentException("invalid character '" + ch + "' in byte array");
            }
            if (flipflop) {
                array[len++] = (byte)(prevNibble << 4 | nibble);
            } else {
                prevNibble = nibble;
            }
            flipflop ^= true;
        }
        if (flipflop) {
            throw new IllegalArgumentException("byte array has an odd number of digits");
        }
        if (len < array.length) {
            byte[] temp = new byte[len];
            System.arraycopy(array, 0, temp, 0, len);
            array = temp;
        }
        return array;
    }
}

