/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.string;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DateEncoder {
    public static final String PATTERN = "[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(\\.[0-9]{3})?(Z)?";
    private static final String FORMAT_SECONDS = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String FORMAT_MILLIS = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String FORMAT_Z_SUFFIX = "'Z'";

    private DateEncoder() {
    }

    public static String encode(Date date) {
        String format = (date.getTime() % 1000L != 0L ? FORMAT_MILLIS : FORMAT_SECONDS) + FORMAT_Z_SUFFIX;
        return DateEncoder.getDateFormat(format).format(date);
    }

    public static Date decode(String string) {
        String format;
        Matcher matcher = Pattern.compile(PATTERN).matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("malformed date string");
        }
        String string2 = format = matcher.group(1) != null ? FORMAT_MILLIS : FORMAT_SECONDS;
        if (matcher.group(2) != null) {
            format = format + FORMAT_Z_SUFFIX;
        }
        try {
            return DateEncoder.getDateFormat(format).parse(matcher.group());
        }
        catch (ParseException e) {
            throw new RuntimeException("unexpected");
        }
    }

    public static SimpleDateFormat getDateFormat(String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setLenient(false);
        dateFormat.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), Locale.US));
        return dateFormat;
    }
}

