/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.text;

import java.lang.reflect.Field;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.dellroad.stuff.validation.SelfValidates;
import org.dellroad.stuff.validation.SelfValidating;
import org.dellroad.stuff.validation.SelfValidationException;

@SelfValidates
public class MessageFmt
implements SelfValidating {
    private List<Segment> segments = new ArrayList<Segment>();

    public MessageFmt() {
    }

    public MessageFmt(Segment ... segments) {
        if (segments == null) {
            throw new IllegalArgumentException("null segments");
        }
        for (int i = 0; i < segments.length; ++i) {
            Segment segment = segments[i];
            if (segment == null) {
                throw new IllegalArgumentException("null segment");
            }
            this.segments.add(segment);
        }
    }

    public MessageFmt(MessageFormat format) {
        this(format, false);
    }

    public MessageFmt(MessageFormat format, boolean captureLocaleDefaults) {
        if (format == null) {
            throw new IllegalArgumentException("null format");
        }
        MessageFormatAccessor accessor = new MessageFormatAccessor();
        Format[] formats = accessor.getFormats(format);
        int[] offsets = accessor.getOffsets(format);
        String pattern = accessor.getPattern(format);
        int maxOffset = accessor.getMaxOffset(format);
        int[] argumentNumbers = accessor.getArgumentNumbers(format);
        Locale locale = !captureLocaleDefaults ? format.getLocale() : null;
        int prevOffset = 0;
        for (int i = 0; i <= maxOffset; ++i) {
            int nextOffset = offsets[i];
            if (nextOffset > prevOffset) {
                this.segments.add(new TextSegment(pattern.substring(prevOffset, nextOffset)));
                prevOffset = nextOffset;
            }
            int argumentNumber = argumentNumbers[i];
            this.segments.add(formats[i] != null ? FormatArgumentSegment.of(formats[i], argumentNumber, locale) : new DefaultArgumentSegment(argumentNumber));
        }
        if (prevOffset < pattern.length()) {
            this.segments.add(new TextSegment(pattern.substring(prevOffset)));
        }
    }

    @NotNull
    @Valid
    public @NotNull @Valid List<@NotNull Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public MessageFormat toMessageFormat() {
        return new MessageFormat(this.toPattern());
    }

    public MessageFormat toMessageFormat(Locale locale) {
        return new MessageFormat(this.toPattern(), locale);
    }

    public String toPattern() {
        return this.segments.stream().map(Segment::toPattern).collect(Collectors.joining());
    }

    public static String escape(String string) {
        return string.replaceAll("'", "''").replaceAll("\\{+", "'$0'");
    }

    public static String unescape(String string) {
        return string.replaceAll("(?<!')'([^']+)'", "$1").replaceAll("''", "'");
    }

    @Override
    public void checkValid(ConstraintValidatorContext context) throws SelfValidationException {
        try {
            this.toMessageFormat(Locale.getDefault(Locale.Category.FORMAT));
        }
        catch (IllegalArgumentException e) {
            throw new SelfValidationException("invalid configuration", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MessageFmt that = (MessageFmt)obj;
        return Objects.equals(this.segments, that.segments);
    }

    public int hashCode() {
        return Objects.hashCode(this.segments);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[segments=" + this.segments + "]";
    }

    private static class MessageFormatAccessor {
        private static final Field FORMATS_FIELD;
        private static final Field OFFSETS_FIELD;
        private static final Field PATTERN_FIELD;
        private static final Field MAX_OFFSET_FIELD;
        private static final Field ARGUMENT_NUMBERS_FIELD;

        private MessageFormatAccessor() {
        }

        public Format[] getFormats(MessageFormat format) {
            try {
                return (Format[])FORMATS_FIELD.get(format);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("internal error", e);
            }
        }

        public int[] getOffsets(MessageFormat format) {
            try {
                return (int[])OFFSETS_FIELD.get(format);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("internal error", e);
            }
        }

        public String getPattern(MessageFormat format) {
            try {
                return (String)PATTERN_FIELD.get(format);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("internal error", e);
            }
        }

        public int getMaxOffset(MessageFormat format) {
            try {
                return (Integer)MAX_OFFSET_FIELD.get(format);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("internal error", e);
            }
        }

        public int[] getArgumentNumbers(MessageFormat format) {
            try {
                return (int[])ARGUMENT_NUMBERS_FIELD.get(format);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("internal error", e);
            }
        }

        static {
            try {
                FORMATS_FIELD = MessageFormat.class.getDeclaredField("formats");
                OFFSETS_FIELD = MessageFormat.class.getDeclaredField("offsets");
                PATTERN_FIELD = MessageFormat.class.getDeclaredField("pattern");
                MAX_OFFSET_FIELD = MessageFormat.class.getDeclaredField("maxOffset");
                ARGUMENT_NUMBERS_FIELD = MessageFormat.class.getDeclaredField("argumentNumbers");
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("internal error", e);
            }
            Stream.of(OFFSETS_FIELD, FORMATS_FIELD, PATTERN_FIELD, MAX_OFFSET_FIELD, ARGUMENT_NUMBERS_FIELD).forEach(field -> {
                try {
                    field.setAccessible(true);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            });
        }
    }

    public static enum DateFormatStandard {
        DEFAULT(2),
        SHORT(3),
        MEDIUM(2),
        LONG(1),
        FULL(0);

        private final int value;

        private DateFormatStandard(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public String description() {
            return this.name().toLowerCase();
        }
    }

    public static class StandardTimeFormatArgumentSegment
    extends AbstractStandardDateFormatArgumentSegment {
        public StandardTimeFormatArgumentSegment() {
        }

        public StandardTimeFormatArgumentSegment(int argumentNumber, DateFormatStandard standard) {
            super(argumentNumber, standard);
        }

        @Override
        protected String getKeyword() {
            return "time";
        }

        @Override
        public void visit(SegmentSwitch target) {
            target.caseStandardTimeFormatArgumentSegment(this);
        }
    }

    public static class StandardDateFormatArgumentSegment
    extends AbstractStandardDateFormatArgumentSegment {
        public StandardDateFormatArgumentSegment() {
        }

        public StandardDateFormatArgumentSegment(int argumentNumber, DateFormatStandard standard) {
            super(argumentNumber, standard);
        }

        @Override
        protected String getKeyword() {
            return "date";
        }

        @Override
        public void visit(SegmentSwitch target) {
            target.caseStandardDateFormatArgumentSegment(this);
        }
    }

    static abstract class AbstractStandardDateFormatArgumentSegment
    extends DateFormatArgumentSegment<DateFormat> {
        private DateFormatStandard standard;

        protected AbstractStandardDateFormatArgumentSegment() {
        }

        protected AbstractStandardDateFormatArgumentSegment(int argumentNumber, DateFormatStandard standard) {
            super(argumentNumber);
            this.standard = standard;
        }

        @NotNull
        public DateFormatStandard getStandard() {
            return this.standard;
        }

        public void setStandard(DateFormatStandard standard) {
            this.standard = standard;
        }

        @Override
        protected String getArgumentSuffix() {
            String result = this.getKeyword();
            if (this.standard != null && !this.standard.equals((Object)DateFormatStandard.DEFAULT)) {
                result = result + "," + this.standard.description();
            }
            return result;
        }

        protected abstract String getKeyword();

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            AbstractStandardDateFormatArgumentSegment that = (AbstractStandardDateFormatArgumentSegment)obj;
            return Objects.equals((Object)this.standard, (Object)that.standard);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ Objects.hashCode((Object)this.standard);
        }
    }

    @SelfValidates
    public static class SimpleDateFormatArgumentSegment
    extends DateFormatArgumentSegment<SimpleDateFormat>
    implements SelfValidating {
        private String pattern;

        public SimpleDateFormatArgumentSegment() {
        }

        public SimpleDateFormatArgumentSegment(int argumentNumber, SimpleDateFormat format) {
            super(argumentNumber);
            if (format == null) {
                throw new IllegalArgumentException("null format");
            }
            this.pattern = format.toPattern();
        }

        @NotNull
        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        protected String getArgumentSuffix() {
            return "date," + this.pattern;
        }

        @Override
        public void visit(SegmentSwitch target) {
            target.caseSimpleDateFormatArgumentSegment(this);
        }

        @Override
        public void checkValid(ConstraintValidatorContext context) throws SelfValidationException {
            if (this.pattern != null) {
                try {
                    new SimpleDateFormat(this.pattern);
                }
                catch (IllegalArgumentException e) {
                    throw new SelfValidationException("invalid SimpleDateFormat pattern \"" + this.pattern + "\"", e);
                }
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            SimpleDateFormatArgumentSegment that = (SimpleDateFormatArgumentSegment)obj;
            return Objects.equals(this.pattern, that.pattern);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ Objects.hashCode(this.pattern);
        }
    }

    public static abstract class DateFormatArgumentSegment<T extends DateFormat>
    extends FormatArgumentSegment<DateFormat> {
        protected DateFormatArgumentSegment() {
        }

        protected DateFormatArgumentSegment(int argumentNumber) {
            super(argumentNumber);
        }
    }

    public static class ChoiceArgumentSegment
    extends NumberFormatArgumentSegment<ChoiceFormat> {
        private List<Option> options;

        public ChoiceArgumentSegment() {
            this.options = new ArrayList<Option>(0);
        }

        public ChoiceArgumentSegment(int argumentNumber, Option ... options) {
            super(argumentNumber);
            if (options == null) {
                throw new IllegalArgumentException("null options");
            }
            this.options = new ArrayList<Option>(options.length);
            for (int i = 0; i < options.length; ++i) {
                Option option = options[i];
                if (option == null) {
                    throw new IllegalArgumentException("null option");
                }
                this.options.add(option);
            }
        }

        public ChoiceArgumentSegment(int argumentNumber, ChoiceFormat format) {
            super(argumentNumber);
            if (format == null) {
                throw new IllegalArgumentException("null format");
            }
            double[] limits = format.getLimits();
            String[] formats = (String[])format.getFormats();
            assert (limits.length == formats.length);
            this.options = new ArrayList<Option>(limits.length);
            for (int i = 0; i < limits.length; ++i) {
                String choice = formats[i];
                if (choice.indexOf(123) == -1) {
                    choice = MessageFmt.escape(choice);
                }
                this.options.add(new Option(limits[i], new MessageFmt(new MessageFormat(choice))));
            }
        }

        @NotNull
        @Size(min=1)
        @Valid
        public @NotNull @Size(min=1) @Valid List<@NotNull Option> getOptions() {
            return this.options;
        }

        public void setOptions(List<Option> options) {
            this.options = options;
        }

        public ChoiceFormat toChoiceFormat() {
            double[] limits = new double[this.options.size()];
            String[] formats = new String[this.options.size()];
            for (int i = 0; i < this.options.size(); ++i) {
                Option option = this.options.get(i);
                limits[i] = option.getLimit();
                formats[i] = option.getFormat().toPattern();
                if (formats[i].indexOf(123) != -1) continue;
                formats[i] = MessageFmt.unescape(formats[i]);
            }
            return new ChoiceFormat(limits, formats);
        }

        @Override
        protected String getArgumentSuffix() {
            return "choice," + this.toChoiceFormat().toPattern();
        }

        @Override
        public void visit(SegmentSwitch target) {
            target.caseChoiceArgumentSegment(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            ChoiceArgumentSegment that = (ChoiceArgumentSegment)obj;
            return Objects.equals(this.options, that.options);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ Objects.hashCode(this.options);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "[argumentNumber=" + this.getArgumentNumber() + ",options=" + this.options + "]";
        }

        public static class Option {
            private double limit;
            private MessageFmt format;

            public Option() {
            }

            public Option(double limit, MessageFmt format) {
                this.limit = limit;
                this.format = format;
            }

            public double getLimit() {
                return this.limit;
            }

            public void setLimit(double limit) {
                this.limit = limit;
            }

            public String getLimitDescription() {
                return new ChoiceFormat(this.limit + "#").toPattern();
            }

            public void setLimitDescription(String limitDescription) {
                double[] limits;
                if (limitDescription == null) {
                    throw new IllegalArgumentException("null limitDescription");
                }
                if (limitDescription.indexOf(35) == -1 && limitDescription.indexOf(60) == -1) {
                    limitDescription = limitDescription + "#";
                }
                if ((limits = new ChoiceFormat(limitDescription).getLimits()).length != 1) {
                    throw new IllegalArgumentException("invalid limitDescription");
                }
                this.limit = limits[0];
            }

            @NotNull
            @Valid
            public MessageFmt getFormat() {
                return this.format;
            }

            public void setFormat(MessageFmt format) {
                this.format = format;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                Option that = (Option)obj;
                return Double.compare(this.limit, that.limit) == 0 && Objects.equals(this.format, that.format);
            }

            public int hashCode() {
                return Double.hashCode(this.limit) ^ Objects.hashCode(this.format);
            }

            public String toString() {
                return this.getClass().getSimpleName() + "[limit=" + this.limit + ",format=" + this.format + "]";
            }
        }
    }

    @SelfValidates
    public static class DecimalArgumentSegment
    extends NumberFormatArgumentSegment<DecimalFormat>
    implements SelfValidating {
        private String pattern;

        public DecimalArgumentSegment() {
        }

        public DecimalArgumentSegment(int argumentNumber, DecimalFormat format) {
            super(argumentNumber);
            if (format == null) {
                throw new IllegalArgumentException("null format");
            }
            this.pattern = format.toPattern();
        }

        @NotNull
        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        protected String getArgumentSuffix() {
            return "number," + this.pattern;
        }

        @Override
        public void visit(SegmentSwitch target) {
            target.caseDecimalArgumentSegment(this);
        }

        @Override
        public void checkValid(ConstraintValidatorContext context) throws SelfValidationException {
            if (this.pattern != null) {
                try {
                    new DecimalFormat(this.pattern);
                }
                catch (IllegalArgumentException e) {
                    throw new SelfValidationException("invalid DecimalFormat pattern \"" + this.pattern + "\"", e);
                }
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            DecimalArgumentSegment that = (DecimalArgumentSegment)obj;
            return Objects.equals(this.pattern, that.pattern);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ Objects.hashCode(this.pattern);
        }
    }

    public static class IntegerArgumentSegment
    extends NumberFormatArgumentSegment<NumberFormat> {
        public IntegerArgumentSegment() {
        }

        public IntegerArgumentSegment(int argumentNumber) {
            super(argumentNumber);
        }

        @Override
        protected String getArgumentSuffix() {
            return "number,integer";
        }

        @Override
        public void visit(SegmentSwitch target) {
            target.caseIntegerArgumentSegment(this);
        }
    }

    public static class PercentArgumentSegment
    extends NumberFormatArgumentSegment<NumberFormat> {
        public PercentArgumentSegment() {
        }

        public PercentArgumentSegment(int argumentNumber) {
            super(argumentNumber);
        }

        @Override
        protected String getArgumentSuffix() {
            return "number,percent";
        }

        @Override
        public void visit(SegmentSwitch target) {
            target.casePercentArgumentSegment(this);
        }
    }

    public static class CurrencyArgumentSegment
    extends NumberFormatArgumentSegment<NumberFormat> {
        public CurrencyArgumentSegment() {
        }

        public CurrencyArgumentSegment(int argumentNumber) {
            super(argumentNumber);
        }

        @Override
        protected String getArgumentSuffix() {
            return "number,currency";
        }

        @Override
        public void visit(SegmentSwitch target) {
            target.caseCurrencyArgumentSegment(this);
        }
    }

    public static class DefaultNumberFormatArgumentSegment
    extends NumberFormatArgumentSegment<NumberFormat> {
        public DefaultNumberFormatArgumentSegment() {
        }

        public DefaultNumberFormatArgumentSegment(int argumentNumber) {
            super(argumentNumber);
        }

        @Override
        protected String getArgumentSuffix() {
            return "number";
        }

        @Override
        public void visit(SegmentSwitch target) {
            target.caseDefaultNumberFormatArgumentSegment(this);
        }
    }

    public static abstract class NumberFormatArgumentSegment<T extends NumberFormat>
    extends FormatArgumentSegment<T> {
        protected NumberFormatArgumentSegment() {
        }

        protected NumberFormatArgumentSegment(int argumentNumber) {
            super(argumentNumber);
        }
    }

    public static abstract class FormatArgumentSegment<T extends Format>
    extends ArgumentSegment {
        protected FormatArgumentSegment() {
        }

        protected FormatArgumentSegment(int argumentNumber) {
            super(argumentNumber);
        }

        public static <T extends Format> FormatArgumentSegment<T> of(T format, int argumentNumber, Locale locale) {
            if (format == null) {
                throw new IllegalArgumentException("null format");
            }
            if (argumentNumber < 0) {
                throw new IllegalArgumentException("negative argumentNumber");
            }
            if (locale != null) {
                if (format.equals(NumberFormat.getInstance(locale))) {
                    return new DefaultNumberFormatArgumentSegment(argumentNumber);
                }
                if (format.equals(NumberFormat.getCurrencyInstance(locale))) {
                    return new CurrencyArgumentSegment(argumentNumber);
                }
                if (format.equals(NumberFormat.getPercentInstance(locale))) {
                    return new PercentArgumentSegment(argumentNumber);
                }
                if (format.equals(NumberFormat.getIntegerInstance(locale))) {
                    return new IntegerArgumentSegment(argumentNumber);
                }
            }
            if (format instanceof DecimalFormat) {
                return new DecimalArgumentSegment(argumentNumber, (DecimalFormat)format);
            }
            if (format instanceof ChoiceFormat) {
                return new ChoiceArgumentSegment(argumentNumber, (ChoiceFormat)format);
            }
            if (format instanceof DateFormat) {
                if (locale != null) {
                    for (DateFormatStandard standard : DateFormatStandard.values()) {
                        if (format.equals(DateFormat.getDateInstance(standard.value(), locale))) {
                            return new StandardDateFormatArgumentSegment(argumentNumber, standard);
                        }
                        if (!format.equals(DateFormat.getTimeInstance(standard.value(), locale))) continue;
                        return new StandardTimeFormatArgumentSegment(argumentNumber, standard);
                    }
                }
                if (format instanceof SimpleDateFormat) {
                    return new SimpleDateFormatArgumentSegment(argumentNumber, (SimpleDateFormat)format);
                }
            }
            throw new IllegalArgumentException("undecipherable format: " + format);
        }
    }

    public static class DefaultArgumentSegment
    extends ArgumentSegment {
        public DefaultArgumentSegment() {
        }

        public DefaultArgumentSegment(int argumentNumber) {
            super(argumentNumber);
        }

        @Override
        protected String getArgumentSuffix() {
            return null;
        }

        @Override
        public void visit(SegmentSwitch target) {
            target.caseDefaultArgumentSegment(this);
        }
    }

    public static abstract class ArgumentSegment
    extends Segment {
        private int argumentNumber;

        protected ArgumentSegment() {
        }

        protected ArgumentSegment(int argumentNumber) {
            this.argumentNumber = argumentNumber;
        }

        @Min(value=0L)
        public @Min(value=0L) int getArgumentNumber() {
            return this.argumentNumber;
        }

        public void setArgumentNumber(int argumentNumber) {
            this.argumentNumber = argumentNumber;
        }

        @Override
        public final String toPattern() {
            StringBuilder buf = new StringBuilder();
            buf.append('{').append(this.argumentNumber);
            String suffix = this.getArgumentSuffix();
            if (suffix != null) {
                buf.append(',').append(suffix);
            }
            buf.append('}');
            return buf.toString();
        }

        protected abstract String getArgumentSuffix();

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            ArgumentSegment that = (ArgumentSegment)obj;
            return this.argumentNumber == that.argumentNumber;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.argumentNumber;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[argumentNumber=" + this.argumentNumber + ",pattern=\"" + this.toPattern() + "\"]";
        }
    }

    public static class TextSegment
    extends Segment {
        private String string;

        public TextSegment() {
        }

        public TextSegment(String string) {
            this.string = string;
        }

        @NotNull
        public String getString() {
            return this.string;
        }

        public void setString(String string) {
            this.string = string;
        }

        @Override
        public String toPattern() {
            return MessageFmt.escape(this.string);
        }

        @Override
        public void visit(SegmentSwitch target) {
            target.caseTextSegment(this);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            TextSegment that = (TextSegment)obj;
            return Objects.equals(this.string, that.string);
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ Objects.hashCode(this.string);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[string=\"" + this.string + "\"]";
        }
    }

    public static class SegmentSwitchAdapter
    implements SegmentSwitch {
        @Override
        public void caseChoiceArgumentSegment(ChoiceArgumentSegment segment) {
            this.caseNumberFormatArgumentSegment(segment);
        }

        @Override
        public void caseCurrencyArgumentSegment(CurrencyArgumentSegment segment) {
            this.caseNumberFormatArgumentSegment(segment);
        }

        @Override
        public void caseDecimalArgumentSegment(DecimalArgumentSegment segment) {
            this.caseNumberFormatArgumentSegment(segment);
        }

        @Override
        public void caseDefaultArgumentSegment(DefaultArgumentSegment segment) {
            this.caseArgumentSegment(segment);
        }

        @Override
        public void caseDefaultNumberFormatArgumentSegment(DefaultNumberFormatArgumentSegment segment) {
            this.caseNumberFormatArgumentSegment(segment);
        }

        @Override
        public void caseIntegerArgumentSegment(IntegerArgumentSegment segment) {
            this.caseNumberFormatArgumentSegment(segment);
        }

        @Override
        public void casePercentArgumentSegment(PercentArgumentSegment segment) {
            this.caseNumberFormatArgumentSegment(segment);
        }

        @Override
        public void caseSimpleDateFormatArgumentSegment(SimpleDateFormatArgumentSegment segment) {
            this.caseDateFormatArgumentSegment(segment);
        }

        @Override
        public void caseStandardDateFormatArgumentSegment(StandardDateFormatArgumentSegment segment) {
            this.caseDateFormatArgumentSegment(segment);
        }

        @Override
        public void caseStandardTimeFormatArgumentSegment(StandardTimeFormatArgumentSegment segment) {
            this.caseDateFormatArgumentSegment(segment);
        }

        @Override
        public void caseTextSegment(TextSegment segment) {
            this.caseSegment(segment);
        }

        protected <T extends DateFormat> void caseDateFormatArgumentSegment(DateFormatArgumentSegment<T> segment) {
            this.caseFormatArgumentSegment(segment);
        }

        protected <T extends NumberFormat> void caseNumberFormatArgumentSegment(NumberFormatArgumentSegment<T> segment) {
            this.caseFormatArgumentSegment(segment);
        }

        protected <T extends Format> void caseFormatArgumentSegment(FormatArgumentSegment<T> segment) {
            this.caseArgumentSegment(segment);
        }

        protected void caseArgumentSegment(ArgumentSegment segment) {
            this.caseSegment(segment);
        }

        protected void caseSegment(Segment segment) {
        }
    }

    public static interface SegmentSwitch {
        public void caseChoiceArgumentSegment(ChoiceArgumentSegment var1);

        public void caseCurrencyArgumentSegment(CurrencyArgumentSegment var1);

        public void caseDecimalArgumentSegment(DecimalArgumentSegment var1);

        public void caseDefaultArgumentSegment(DefaultArgumentSegment var1);

        public void caseDefaultNumberFormatArgumentSegment(DefaultNumberFormatArgumentSegment var1);

        public void caseIntegerArgumentSegment(IntegerArgumentSegment var1);

        public void casePercentArgumentSegment(PercentArgumentSegment var1);

        public void caseSimpleDateFormatArgumentSegment(SimpleDateFormatArgumentSegment var1);

        public void caseStandardDateFormatArgumentSegment(StandardDateFormatArgumentSegment var1);

        public void caseStandardTimeFormatArgumentSegment(StandardTimeFormatArgumentSegment var1);

        public void caseTextSegment(TextSegment var1);
    }

    public static abstract class Segment {
        public abstract String toPattern();

        public abstract void visit(SegmentSwitch var1);

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj != null && obj.getClass() == this.getClass();
        }

        public int hashCode() {
            return Objects.hashCode(this.getClass());
        }
    }
}

