/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.util;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.OptionalDouble;

public class Averager
implements Cloneable {
    private int count;
    private double mean;
    private double m2;

    public Averager() {
    }

    public Averager(double firstValue) {
        this.addValue(firstValue);
    }

    private Averager(int count, double mean, double m2) {
        this.count = count;
        this.mean = mean;
        this.m2 = m2;
    }

    public void addValue(double value) {
        Preconditions.checkArgument((boolean)Double.isFinite(value), (Object)"non-finite value");
        ++this.count;
        double delta = value - this.mean;
        this.mean += delta / (double)this.count;
        this.m2 += delta * (value - this.mean);
    }

    public Averager add(Averager that) {
        Preconditions.checkNotNull((Object)that, (Object)"null that");
        if (this.count == 0) {
            return that.clone();
        }
        if (that.count == 0) {
            return this.clone();
        }
        int combinedCount = this.count + that.count;
        double sigma = that.mean - this.mean;
        double combinedMean = this.mean + sigma * (double)that.count / (double)combinedCount;
        double combinedM2 = this.m2 + that.m2 + sigma * sigma * (double)(this.count * that.count) / (double)combinedCount;
        return new Averager(combinedCount, combinedMean, combinedM2);
    }

    public Averager subtract(Averager that) {
        Preconditions.checkNotNull((Object)that, (Object)"null that");
        Preconditions.checkArgument((this.count >= that.count ? 1 : 0) != 0, (Object)"subtracting too many data points");
        if (that.count == 0) {
            return this.clone();
        }
        int resultCount = this.count - that.count;
        double sigma = (this.mean - that.mean) * (double)this.count / (double)resultCount;
        double resultMean = sigma + that.mean;
        double resultM2 = resultCount > 1 ? this.m2 - that.m2 - sigma * sigma * (double)(that.count * resultCount) / (double)this.count : 0.0;
        return new Averager(resultCount, resultMean, resultM2);
    }

    public void reset() {
        this.count = 0;
        this.mean = 0.0;
        this.m2 = 0.0;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public OptionalDouble getAverage() {
        if (this.count == 0) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.mean);
    }

    public OptionalDouble getVariance() {
        if (this.count == 0) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.m2 / (double)this.count);
    }

    public OptionalDouble getStandardDeviation() {
        if (this.count == 0) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(Math.sqrt(this.m2 / (double)this.count));
    }

    public OptionalDouble getSampleVariance() {
        if (this.count < 2) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.m2 / (double)(this.count - 1));
    }

    public OptionalDouble getSampleStandardDeviation() {
        if (this.count < 2) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(Math.sqrt(this.m2 / (double)(this.count - 1)));
    }

    public OptionalDouble getCoefficientOfVariation() {
        if (this.count == 0) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(Math.sqrt(this.m2 / (double)this.count) / this.mean);
    }

    public String toString() {
        if (this.count == 0) {
            return "no data";
        }
        return String.format(Locale.US, "num=%d, avg=%f, stddev=%f", this.count, this.getAverage().getAsDouble(), this.getStandardDeviation().getAsDouble());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Averager that = (Averager)obj;
        return this.count == that.count && Double.compare(this.mean, that.mean) == 0 && Double.compare(this.m2, that.m2) == 0;
    }

    public int hashCode() {
        return this.count ^ Double.hashCode(this.mean) ^ Double.hashCode(this.m2);
    }

    public Averager clone() {
        try {
            return (Averager)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException();
        }
    }
}

