/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import org.dellroad.stuff.util.LongSet;

public class LongMap<V>
extends AbstractMap<Long, V>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4931628136892145403L;
    private static final float EXPAND_THRESHOLD = 0.7f;
    private static final float SHRINK_THRESHOLD = 0.25f;
    private static final int MIN_LOG2_LENGTH = 4;
    private static final int MAX_LOG2_LENGTH = 30;
    private long[] keys;
    private V[] values;
    private int size;
    private int log2len;
    private int upperSizeLimit;
    private int lowerSizeLimit;
    private int numHashShifts;
    private AtomicInteger modcount = new AtomicInteger();

    public LongMap() {
        this(0, true);
    }

    public LongMap(int capacity) {
        this(capacity, true);
    }

    public LongMap(Map<? extends Number, ? extends V> map) {
        this(map.size(), true);
        for (Map.Entry<Number, V> entry : map.entrySet()) {
            Number key = entry.getKey();
            if (key == null) {
                throw new IllegalArgumentException("map contains null key");
            }
            this.put(key.longValue(), entry.getValue());
        }
    }

    LongMap(int capacity, boolean withValues) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0");
        }
        capacity &= 0x3FFFFFFF;
        capacity = (int)((float)capacity / 0.7f);
        capacity = Math.max(1, capacity);
        this.log2len = 32 - Integer.numberOfLeadingZeros(capacity - 1);
        this.log2len = Math.max(4, this.log2len);
        this.log2len = Math.min(30, this.log2len);
        this.createArrays(withValues);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object obj) {
        if (!(obj instanceof Long)) {
            return false;
        }
        return this.containsKey((Long)obj);
    }

    public boolean containsKey(long key) {
        if (key == 0L) {
            return false;
        }
        int slot = this.findSlot(key);
        if (this.keys[slot] == key) {
            return true;
        }
        assert (this.keys[slot] == 0L);
        return false;
    }

    @Override
    public V get(Object obj) {
        if (!(obj instanceof Long)) {
            return null;
        }
        return this.get((Long)obj);
    }

    public V get(long key) {
        if (key == 0L) {
            return null;
        }
        int slot = this.findSlot(key);
        if (this.keys[slot] == key) {
            return this.values != null ? (V)this.values[slot] : null;
        }
        assert (this.keys[slot] == 0L);
        return null;
    }

    @Override
    public V put(Long key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        return this.put((long)key, value);
    }

    @Override
    public V put(long key, V value) {
        if (key == 0L) {
            throw new IllegalArgumentException("key is zero");
        }
        return this.insert(key, value);
    }

    @Override
    public V remove(Object obj) {
        if (!(obj instanceof Long)) {
            return null;
        }
        return this.remove((Long)obj);
    }

    public V remove(long key) {
        if (key == 0L) {
            return null;
        }
        return this.exsert(key, true);
    }

    @Override
    public void clear() {
        this.log2len = 4;
        this.createArrays(this.values != null);
        this.size = 0;
        this.modcount.incrementAndGet();
    }

    public LongSet keySet() {
        return new LongSet(this);
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        return new EntrySet();
    }

    public Map.Entry<Long, V> removeOne() {
        return this.removeOne(this.modcount.get() * 11171);
    }

    private Map.Entry<Long, V> removeOne(int offset) {
        if (this.size == 0) {
            return null;
        }
        int mask = this.keys.length - 1;
        for (int i = 0; i < this.keys.length; ++i) {
            int slot = offset + i & mask;
            long key = this.keys[slot];
            if (key == 0L) continue;
            Object value = this.values != null ? (Object)this.values[slot] : null;
            this.exsert(slot, true);
            return new AbstractMap.SimpleImmutableEntry<Long, Object>(key, value);
        }
        return null;
    }

    String debugDump() {
        StringBuilder buf = new StringBuilder();
        buf.append("LONGMAP: size=" + this.size + " len=" + this.keys.length + " modcount=" + this.modcount.get());
        for (int i = 0; i < this.keys.length; ++i) {
            buf.append('\n').append(String.format(" [%2d] %016x (hash %d)", i, this.keys[i], this.hash(this.keys[i])));
        }
        return buf.toString();
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public LongMap<V> clone() {
        LongMap clone;
        try {
            clone = (LongMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.keys = (long[])clone.keys.clone();
        clone.modcount = new AtomicInteger(clone.modcount.get());
        if (clone.values != null) {
            clone.values = (Object[])clone.values.clone();
        }
        return clone;
    }

    public LongMap<V> deepClone(UnaryOperator<V> valueCloner) {
        if (valueCloner == null) {
            throw new IllegalArgumentException("null valueCloner");
        }
        Object clone = this.clone();
        if (((LongMap)clone).values != null) {
            for (int i = 0; i < ((LongMap)clone).values.length; ++i) {
                V value = ((LongMap)clone).values[i];
                if (value == null) continue;
                ((LongMap)clone).values[i] = valueCloner.apply(value);
            }
        }
        return clone;
    }

    long[] getKeys() {
        return this.keys;
    }

    V getValue(int slot) {
        return this.values[slot];
    }

    void setValue(int slot, V value) {
        this.values[slot] = value;
    }

    Long[] toKeysArray() {
        Long[] array = new Long[this.size];
        int index = 0;
        for (int slot = 0; slot < this.keys.length; ++slot) {
            long value = this.keys[slot];
            if (value == 0L) continue;
            array[index++] = value;
        }
        return array;
    }

    long[] toKeysLongArray() {
        long[] array = new long[this.size];
        int index = 0;
        for (int slot = 0; slot < this.keys.length; ++slot) {
            long value = this.keys[slot];
            if (value == 0L) continue;
            array[index++] = value;
        }
        return array;
    }

    private V insert(long key, V value) {
        boolean expansionNeeded;
        assert (key != 0L);
        assert (this.values != null || value == null);
        int slot = this.findSlot(key);
        if (this.keys[slot] == key) {
            if (this.values == null) {
                return null;
            }
            V prev = this.values[slot];
            this.values[slot] = value;
            return prev;
        }
        boolean bl = expansionNeeded = this.size >= this.upperSizeLimit;
        if (expansionNeeded && this.log2len >= 30) {
            throw new IllegalStateException("maximum capacity reached");
        }
        assert (this.keys[slot] == 0L);
        this.keys[slot] = key;
        if (this.values != null) {
            assert (this.values[slot] == null);
            this.values[slot] = value;
        }
        ++this.size;
        if (expansionNeeded) {
            ++this.log2len;
            this.resize();
        }
        this.modcount.incrementAndGet();
        return null;
    }

    private V exsert(long key, boolean allowResize) {
        int slot = this.findSlot(key);
        if (this.keys[slot] == 0L) {
            assert (this.values == null || this.values[slot] == null);
            return null;
        }
        assert (this.keys[slot] == key);
        return this.exsert(slot, allowResize);
    }

    private V exsert(int slot, boolean allowResize) {
        assert (this.keys[slot] != 0L);
        V ovalue = this.values != null ? (V)this.values[slot] : null;
        int i = slot;
        int j = slot;
        block0: while (true) {
            long jkey;
            this.keys[i] = 0L;
            if (this.values != null) {
                this.values[i] = null;
            }
            while ((jkey = this.keys[j = j + 1 & this.keys.length - 1]) != 0L) {
                Object jvalue = this.values != null ? this.values[j] : null;
                int k = this.hash(jkey);
                if (i <= j ? i < k && k <= j : i < k || k <= j) continue;
                this.keys[i] = jkey;
                if (this.values != null) {
                    this.values[i] = jvalue;
                }
                i = j;
                continue block0;
            }
            break;
        }
        if (--this.size < this.lowerSizeLimit && allowResize && this.log2len > 4) {
            --this.log2len;
            this.resize();
        }
        this.modcount.incrementAndGet();
        return ovalue;
    }

    private int findSlot(long value) {
        assert (value != 0L);
        int slot = this.hash(value);
        long existing;
        while ((existing = this.keys[slot]) != 0L && existing != value) {
            slot = slot + 1 & this.keys.length - 1;
        }
        return slot;
    }

    private int hash(long value) {
        int shift = this.log2len;
        int hash = (int)value;
        for (int i = 0; i < this.numHashShifts; ++i) {
            hash ^= (int)(value >>>= shift);
        }
        return hash & this.keys.length - 1;
    }

    private void resize() {
        long[] oldKeys = this.keys;
        V[] oldValues = this.values;
        assert (oldValues == null || oldValues.length == oldKeys.length);
        this.createArrays(oldValues != null);
        for (int oldSlot = 0; oldSlot < oldKeys.length; ++oldSlot) {
            long key = oldKeys[oldSlot];
            if (key == 0L) {
                assert (oldValues == null || oldValues[oldSlot] == null);
                continue;
            }
            int newSlot = this.findSlot(key);
            assert (this.keys[newSlot] == 0L);
            this.keys[newSlot] = key;
            if (this.values == null) continue;
            assert (this.values[newSlot] == null);
            this.values[newSlot] = oldValues[oldSlot];
        }
    }

    private void createArrays(boolean withValues) {
        assert (this.log2len >= 4);
        assert (this.log2len <= 30);
        int arrayLength = 1 << this.log2len;
        this.lowerSizeLimit = this.log2len > 4 ? (int)(0.25f * (float)arrayLength) : 0;
        this.upperSizeLimit = this.log2len < 30 ? (int)(0.7f * (float)arrayLength) : arrayLength;
        this.numHashShifts = (64 + (this.log2len - 1)) / this.log2len;
        this.numHashShifts = Math.min(12, this.numHashShifts);
        this.keys = new long[arrayLength];
        if (withValues) {
            this.values = new Object[arrayLength];
        }
    }

    class Entry
    extends AbstractMap.SimpleEntry<Long, V> {
        Entry(int slot) {
            super(LongMap.this.keys[slot], LongMap.this.values != null ? LongMap.this.values[slot] : null);
        }

        @Override
        public V setValue(V value) {
            assert (LongMap.this.values != null);
            long key = (Long)this.getKey();
            int slot = LongMap.this.findSlot(key);
            if (LongMap.this.keys[slot] != key) {
                throw new IllegalStateException("key no longer exists: " + key);
            }
            ((LongMap)LongMap.this).values[slot] = value;
            return super.setValue(value);
        }
    }

    class EntrySetIterator
    implements Iterator<Map.Entry<Long, V>> {
        private int modcount;
        private int removeSlot;
        private int nextSlot;

        EntrySetIterator() {
            this.modcount = LongMap.this.modcount.get();
            this.removeSlot = -1;
        }

        @Override
        public boolean hasNext() {
            return this.findNext(false) != -1;
        }

        @Override
        public Entry next() {
            int slot = this.findNext(true);
            if (slot == -1) {
                throw new NoSuchElementException();
            }
            long key = LongMap.this.keys[slot];
            assert (key != 0L);
            this.removeSlot = slot;
            return new Entry(slot);
        }

        @Override
        public void remove() {
            if (this.removeSlot == -1) {
                throw new IllegalStateException();
            }
            if (this.modcount != LongMap.this.modcount.get()) {
                throw new ConcurrentModificationException();
            }
            LongMap.this.exsert(this.removeSlot, false);
            if (this.removeSlot == this.nextSlot - 1 && LongMap.this.keys[this.removeSlot] != 0L) {
                --this.nextSlot;
            }
            this.removeSlot = -1;
            ++this.modcount;
        }

        private int findNext(boolean advance) {
            if (this.modcount != LongMap.this.modcount.get()) {
                throw new ConcurrentModificationException();
            }
            for (int slot = this.nextSlot; slot < LongMap.this.keys.length; ++slot) {
                if (LongMap.this.keys[slot] == 0L) continue;
                this.nextSlot = advance ? slot + 1 : slot;
                return slot;
            }
            return -1;
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<Long, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Long, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return LongMap.this.size;
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object key = entry.getKey();
            Object actualValue = LongMap.this.get(key);
            if (actualValue == null && !LongMap.this.containsKey(key)) {
                return false;
            }
            return Objects.equals(entry.getValue(), actualValue);
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Object key = entry.getKey();
            Object actualValue = LongMap.this.get(key);
            if (actualValue == null && !LongMap.this.containsKey(key)) {
                return false;
            }
            if (Objects.equals(entry.getValue(), actualValue)) {
                LongMap.this.remove(key);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            LongMap.this.clear();
        }

        @Override
        public int hashCode() {
            long[] keyArray = LongMap.this.keys;
            Object[] valueArray = LongMap.this.values;
            int hash = 0;
            for (int i = 0; i < keyArray.length; ++i) {
                Object value;
                long key = keyArray[i];
                if (key == 0L) continue;
                int entryHash = (int)(key >>> 32) ^ (int)key;
                if (valueArray != null && (value = valueArray[i]) != null) {
                    entryHash ^= value.hashCode();
                }
                hash += entryHash;
            }
            return hash;
        }
    }
}

