/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.log4j.WriterAppender;

public class ThreadLogger
extends WriterAppender {
    private static final InheritableThreadLocal<WriterInfo> CURRENT_WRITER = new InheritableThreadLocal<WriterInfo>(){

        @Override
        protected WriterInfo childValue(WriterInfo writerInfo) {
            return writerInfo != null && writerInfo.isInherit() ? writerInfo : null;
        }
    };

    public ThreadLogger() {
        this.setWriter(new ThreadWriter());
    }

    public static void setLogDestination(Writer writer, boolean inherit) {
        CURRENT_WRITER.set(writer != null ? new WriterInfo(writer, inherit) : null);
    }

    public static void setLogDestination(Writer writer) {
        ThreadLogger.setLogDestination(writer, true);
    }

    public static Writer getLogDestination() {
        WriterInfo writerInfo = (WriterInfo)CURRENT_WRITER.get();
        return writerInfo != null ? writerInfo.getWriter() : null;
    }

    protected boolean checkEntryConditions() {
        return CURRENT_WRITER.get() != null && super.checkEntryConditions();
    }

    private static class ThreadWriter
    extends Writer {
        private ThreadWriter() {
        }

        @Override
        public void write(char[] buf, int off, int len) throws IOException {
            WriterInfo writerInfo = (WriterInfo)CURRENT_WRITER.get();
            if (writerInfo != null) {
                writerInfo.getWriter().write(buf, off, len);
            }
        }

        @Override
        public void close() throws IOException {
            WriterInfo writerInfo = (WriterInfo)CURRENT_WRITER.get();
            if (writerInfo != null) {
                writerInfo.getWriter().close();
            }
        }

        @Override
        public void flush() throws IOException {
            WriterInfo writerInfo = (WriterInfo)CURRENT_WRITER.get();
            if (writerInfo != null) {
                writerInfo.getWriter().flush();
            }
        }
    }

    private static class WriterInfo {
        private final Writer writer;
        private final boolean inherit;

        WriterInfo(Writer writer, boolean inherit) {
            this.writer = writer;
            this.inherit = inherit;
        }

        public Writer getWriter() {
            return this.writer;
        }

        public boolean isInherit() {
            return this.inherit;
        }
    }
}

