/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.validation;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintValidatorContext;
import org.dellroad.stuff.validation.AbstractValidator;
import org.dellroad.stuff.validation.Unique;
import org.dellroad.stuff.validation.Uniquifier;
import org.dellroad.stuff.validation.ValidationContext;

public class UniqueValidator
extends AbstractValidator<Unique, Object> {
    private String domain;
    private Uniquifier<Object> uniquifier;

    @Override
    public void initialize(Unique annotation) {
        super.initialize(annotation);
        this.domain = annotation.domain();
        Class<Uniquifier<?>> uniquifierClass = annotation.uniquifier();
        try {
            this.uniquifier = uniquifierClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("can't create an instance of " + uniquifierClass + ": " + e.getMessage(), e);
        }
    }

    public boolean isValid(Object propertyValue, ConstraintValidatorContext context) {
        Object uniqueValue;
        ValidationContext<?> validationContext;
        if (propertyValue == null) {
            return true;
        }
        if (propertyValue instanceof Collection) {
            return this.isCollectionValid((Collection)propertyValue, context);
        }
        if (propertyValue instanceof Map) {
            return this.isCollectionValid(((Map)propertyValue).values(), context);
        }
        try {
            validationContext = ValidationContext.getCurrentContext();
        }
        catch (ClassCastException e) {
            return true;
        }
        try {
            uniqueValue = this.uniquifier.getUniqued(propertyValue);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("uniquifier " + ((Unique)this.annotation).uniquifier() + " does not support uniquifying values of type " + propertyValue.getClass());
        }
        if (uniqueValue == null) {
            return true;
        }
        Set<Object> uniqueDomain = validationContext.getUniqueDomain(this.domain);
        if (!uniqueDomain.add(uniqueValue)) {
            this.setViolation(context, "non-unique value `" + uniqueValue + "' in uniqueness domain `" + this.domain + "'");
            return false;
        }
        return true;
    }
}

