/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.dellroad.stuff.java.ThreadLocalHolder;

public class ValidationContext<T> {
    private static final ThreadLocalHolder<ValidationContext<?>> CURRENT = new ThreadLocalHolder();
    private final HashMap<String, Set<Object>> uniqueDomainMap = new HashMap();
    private final T root;
    private final Class<?>[] groups;

    public ValidationContext(T root, Class<?> ... groups) {
        if (root == null) {
            throw new IllegalArgumentException("null root");
        }
        if (groups == null) {
            throw new IllegalArgumentException("null groups");
        }
        this.root = root;
        this.groups = groups;
    }

    public final T getRoot() {
        return this.root;
    }

    public final Class<?>[] getGroups() {
        return (Class[])this.groups.clone();
    }

    public Set<ConstraintViolation<T>> validate() {
        return this.validate(Validation.buildDefaultValidatorFactory().getValidator());
    }

    public Set<ConstraintViolation<T>> validate(Validator validator) {
        return this.validate(validator, this.root);
    }

    public <S> Set<ConstraintViolation<S>> validate(Validator validator, S target) {
        if (validator == null) {
            throw new IllegalArgumentException("null validator");
        }
        if (target == null) {
            throw new IllegalArgumentException("null target");
        }
        if (CURRENT.get() != null) {
            throw new IllegalStateException("re-entrant invocation is not allowed");
        }
        return CURRENT.invoke(this, () -> validator.validate(target, (Class[])this.groups));
    }

    public static ValidationContext<?> getCurrentContext() {
        ValidationContext<?> context = CURRENT.get();
        if (context == null) {
            throw new IllegalStateException("current thread is not executing validate()");
        }
        return context;
    }

    public static <V extends ValidationContext<?>> V getCurrentContext(Class<V> type) {
        return (V)((ValidationContext)type.cast(ValidationContext.getCurrentContext()));
    }

    public static Object getCurrentRoot() {
        return ValidationContext.getCurrentContext().getRoot();
    }

    public static <T> T getCurrentRoot(Class<T> type) {
        return type.cast(ValidationContext.getCurrentRoot());
    }

    public static ThreadLocalHolder<ValidationContext<?>> getThreadLocalHolder() {
        return CURRENT;
    }

    public Set<Object> getUniqueDomain(String domain) {
        Set<Object> uniqueDomain = this.uniqueDomainMap.get(domain);
        if (uniqueDomain == null) {
            uniqueDomain = new HashSet<Object>();
            this.uniqueDomainMap.put(domain, uniqueDomain);
        }
        return uniqueDomain;
    }
}

