/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.xml;

import java.util.Arrays;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.dellroad.stuff.xml.EventWriterDelegate;

public class IndentXMLEventWriter
extends EventWriterDelegate {
    protected final XMLEventFactory factory;
    private final int indent;
    private int lastEvent = -1;
    private int depth;

    public IndentXMLEventWriter(XMLEventWriter writer, XMLEventFactory factory, int indent) {
        super(writer);
        if (factory == null) {
            throw new IllegalArgumentException("null factory");
        }
        this.factory = factory;
        this.indent = indent;
    }

    public IndentXMLEventWriter(XMLEventWriter writer, int indent) {
        this(writer, XMLEventFactory.newFactory(), indent);
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        block0 : switch (event.getEventType()) {
            case 1: {
                switch (this.lastEvent) {
                    case 1: 
                    case 2: {
                        this.indent(this.depth);
                        break;
                    }
                }
                ++this.depth;
                break;
            }
            case 2: {
                if (this.depth == 0) {
                    throw new IllegalArgumentException("end element with no corresponding start element: " + event);
                }
                --this.depth;
                switch (this.lastEvent) {
                    case 1: {
                        break block0;
                    }
                    case 2: {
                        this.indent(this.depth);
                        break block0;
                    }
                }
                break;
            }
        }
        this.lastEvent = event.getEventType();
        super.add(event);
    }

    @Override
    public void add(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            this.add(reader.nextEvent());
        }
    }

    protected void indent(int depth) throws XMLStreamException {
        if (this.indent < 0) {
            return;
        }
        char[] buf = new char[1 + depth * this.indent];
        Arrays.fill(buf, ' ');
        buf[0] = 10;
        super.add(this.factory.createIgnorableSpace(new String(buf)));
    }
}

