/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.spring;

import java.util.HashSet;
import org.dellroad.stuff.schema.AbstractSchemaUpdate;
import org.dellroad.stuff.schema.SchemaUpdate;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

public abstract class AbstractSpringSchemaUpdate<T>
extends AbstractSchemaUpdate<T>
implements BeanNameAware,
BeanFactoryAware,
InitializingBean {
    protected String beanName;
    protected BeanFactory beanFactory;

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.beanFactory == null) {
            throw new IllegalArgumentException("no BeanFactory configured");
        }
        if (this.beanName == null) {
            throw new IllegalArgumentException("no beanName configured");
        }
        this.setName(this.beanName);
        this.setRequiredPredecessorsFromDependencies();
    }

    protected void setRequiredPredecessorsFromDependencies() {
        if (!(this.beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalArgumentException("BeanFactory is not a ConfigurableBeanFactory: " + String.valueOf(this.beanFactory));
        }
        ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)this.beanFactory;
        String[] predecessorNames = configurableBeanFactory.getDependenciesForBean(this.beanName);
        HashSet<SchemaUpdate> predecessors = new HashSet<SchemaUpdate>(predecessorNames.length);
        String[] stringArray = predecessorNames;
        int n = predecessorNames.length;
        int n2 = 0;
        while (n2 < n) {
            String predecessorName = stringArray[n2];
            try {
                predecessors.add((SchemaUpdate)configurableBeanFactory.getBean(predecessorName, SchemaUpdate.class));
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            }
            catch (BeanNotOfRequiredTypeException beanNotOfRequiredTypeException) {}
            ++n2;
        }
        this.setRequiredPredecessors(predecessors);
    }
}

