/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.spring;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.springframework.scheduling.TaskScheduler;

public abstract class DelayedAction
implements Runnable {
    private final Lock lock;
    private final Object objLock;
    private final TaskScheduler taskScheduler;
    private final ScheduledExecutorService executorService;
    private ScheduledFuture<?> future;
    private Instant futureInstant;

    protected DelayedAction(Object lock, TaskScheduler taskScheduler) {
        this(null, lock, taskScheduler, null);
        if (taskScheduler == null) {
            throw new IllegalArgumentException("null taskScheduler");
        }
    }

    protected DelayedAction(Object lock, ScheduledExecutorService executorService) {
        this(null, lock, null, executorService);
        if (executorService == null) {
            throw new IllegalArgumentException("null executorService");
        }
    }

    protected DelayedAction(Lock lock, TaskScheduler taskScheduler) {
        this(lock, null, taskScheduler, null);
        if (lock == null) {
            throw new IllegalArgumentException("null lock");
        }
        if (taskScheduler == null) {
            throw new IllegalArgumentException("null taskScheduler");
        }
    }

    protected DelayedAction(Lock lock, ScheduledExecutorService executorService) {
        this(lock, null, null, executorService);
        if (lock == null) {
            throw new IllegalArgumentException("null lock");
        }
        if (executorService == null) {
            throw new IllegalArgumentException("null executorService");
        }
    }

    private DelayedAction(Lock lock, Object objLock, TaskScheduler taskScheduler, ScheduledExecutorService executorService) {
        this.lock = lock;
        this.objLock = lock != null ? null : (objLock != null ? objLock : this);
        this.taskScheduler = taskScheduler;
        this.executorService = executorService;
    }

    public void schedule(final Instant instant) {
        this.runLocked(new Runnable(){

            @Override
            public void run() {
                DelayedAction.this.scheduleWhileLocked(instant);
            }
        });
    }

    private void scheduleWhileLocked(final Instant instant) {
        if (instant == null) {
            throw new IllegalArgumentException("null instant");
        }
        if (this.future != null) {
            if (instant.compareTo(this.futureInstant) >= 0) {
                return;
            }
            this.cancel();
        }
        this.future = this.schedule(new Runnable(){

            @Override
            public void run() {
                DelayedAction.this.futureInvoked(instant);
            }
        }, instant);
        this.futureInstant = instant;
    }

    public void cancel() {
        this.runLocked(new Runnable(){

            @Override
            public void run() {
                DelayedAction.this.cancelWhileLocked();
            }
        });
    }

    private void cancelWhileLocked() {
        if (this.future == null) {
            return;
        }
        this.future.cancel(false);
        this.future = null;
        this.futureInstant = null;
    }

    public boolean isScheduled() {
        AtomicBoolean result = new AtomicBoolean();
        this.runLocked(() -> result.set(this.future != null));
        return result.get();
    }

    public Instant getScheduledTime() {
        AtomicReference result = new AtomicReference();
        this.runLocked(() -> result.set(this.futureInstant));
        return (Instant)result.get();
    }

    protected ScheduledFuture<?> schedule(Runnable action, Instant instant) {
        if (action == null) {
            throw new IllegalArgumentException("null action");
        }
        if (instant == null) {
            throw new IllegalArgumentException("null instant");
        }
        if (this.taskScheduler != null) {
            return this.taskScheduler.schedule(action, instant);
        }
        Instant now = Instant.now();
        if (instant.compareTo(now) < 0) {
            instant = now;
        }
        return this.executorService.schedule(action, now.until(instant, ChronoUnit.MILLIS), TimeUnit.MILLISECONDS);
    }

    private void futureInvoked(final Instant instant) {
        this.runLocked(new Runnable(){

            @Override
            public void run() {
                DelayedAction.this.futureInvokedWhileLocked(instant);
            }
        });
    }

    private void futureInvokedWhileLocked(Instant instant) {
        if (this.futureInstant != instant) {
            return;
        }
        this.future = null;
        this.futureInstant = null;
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLocked(Runnable action) {
        if (this.objLock != null) {
            Object object = this.objLock;
            synchronized (object) {
                action.run();
            }
        }
        this.lock.lock();
        try {
            action.run();
        }
        finally {
            this.lock.unlock();
        }
    }
}

