/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.spring;

import org.dellroad.stuff.schema.SQLCommandList;
import org.dellroad.stuff.spring.ResourceReaderFactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class SQLBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String SPLIT_PATTERN_ATTRIBUTE = "split-pattern";
    private static final String RESOURCE_ATTRIBUTE = "resource";
    private static final String CHARSET_ATTRIBUTE = "charset";
    private boolean ignoreId;

    SQLBeanDefinitionParser() {
    }

    SQLBeanDefinitionParser(boolean ignoreId) {
        this.ignoreId = ignoreId;
    }

    protected boolean shouldGenerateId() {
        return this.ignoreId ? true : super.shouldGenerateId();
    }

    protected Class<SQLCommandList> getBeanClass(Element element) {
        return SQLCommandList.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Attr attr = element.getAttributeNodeNS(null, SPLIT_PATTERN_ATTRIBUTE);
        if (attr != null) {
            builder.addPropertyValue("splitPattern", (Object)attr.getValue());
        }
        if ((attr = element.getAttributeNodeNS(null, RESOURCE_ATTRIBUTE)) != null) {
            Node node = element.getFirstChild();
            if (node != null) {
                this.bogus(element, parserContext);
            }
            BeanDefinitionBuilder resourceBuilder = BeanDefinitionBuilder.genericBeanDefinition(ResourceReaderFactoryBean.class);
            resourceBuilder.addPropertyValue(RESOURCE_ATTRIBUTE, (Object)attr.getValue());
            attr = element.getAttributeNodeNS(null, CHARSET_ATTRIBUTE);
            if (attr != null) {
                resourceBuilder.addPropertyValue("characterEncoding", (Object)attr.getValue());
            }
            builder.addPropertyValue("SQLScript", (Object)resourceBuilder.getBeanDefinition());
        } else {
            builder.addPropertyValue("SQLScript", (Object)this.getNestedSQL(element, parserContext));
        }
    }

    String getNestedSQL(Element element, ParserContext parserContext) {
        Node node = element.getFirstChild();
        if (node == null) {
            this.bogus(element, parserContext);
        }
        StringBuilder buf = new StringBuilder();
        while (node != null) {
            if (!(node instanceof Text)) {
                this.bogus(element, parserContext);
            }
            buf.append(((Text)node).getData());
            node = node.getNextSibling();
        }
        return buf.toString();
    }

    private void bogus(Element element, ParserContext parserContext) {
        String message = "<" + element.getTagName() + "> beans must have either a \"resource\" attribute or nested SQL content, but not both";
        parserContext.getReaderContext().fatal(message, parserContext.extractSource((Object)element));
    }
}

