/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.spring;

import org.dellroad.stuff.spring.AbstractBeanDefinitionParser;
import org.dellroad.stuff.spring.SQLBeanDefinitionParser;
import org.dellroad.stuff.spring.SpringSQLSchemaUpdate;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class SQLUpdateBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String SINGLE_ACTION_ATTRIBUTE = "single-action";

    SQLUpdateBeanDefinitionParser() {
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String singleAction;
        String id = element.getAttribute("id");
        if (!StringUtils.hasText((String)id)) {
            this.error(element, parserContext, "<" + element.getTagName() + "> beans must have an \"id\" attribute that provides a unique name for the update");
        }
        AbstractBeanDefinition update = this.createBeanDefinition(SpringSQLSchemaUpdate.class, element, parserContext);
        this.parseStandardAttributes(update, element, parserContext);
        update.getPropertyValues().add("SQLCommandList", (Object)new SQLBeanDefinitionParser(true).parse(element, parserContext));
        String[] predecessors = update.getDependsOn();
        if (predecessors != null) {
            Object source = parserContext.extractSource((Object)element);
            ManagedSet predecessorSet = new ManagedSet(predecessors.length);
            predecessorSet.setSource(source);
            String[] stringArray = predecessors;
            int n = predecessors.length;
            int n2 = 0;
            while (n2 < n) {
                String predecessor = stringArray[n2];
                RuntimeBeanReference beanReference = new RuntimeBeanReference(predecessor, false);
                beanReference.setSource(source);
                predecessorSet.add((Object)beanReference);
                ++n2;
            }
            update.getPropertyValues().add("requiredPredecessors", (Object)predecessorSet);
        }
        if (StringUtils.hasText((String)(singleAction = element.getAttribute(SINGLE_ACTION_ATTRIBUTE)))) {
            update.getPropertyValues().add("singleAction", (Object)Boolean.valueOf(singleAction));
        }
        return update;
    }
}

