/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.spring;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Comparator;
import org.dellroad.stuff.schema.DatabaseAction;
import org.dellroad.stuff.schema.SQLCommand;
import org.dellroad.stuff.schema.SQLSchemaUpdater;
import org.dellroad.stuff.schema.SchemaUpdate;
import org.dellroad.stuff.spring.BeanNameComparator;
import org.dellroad.stuff.spring.SpringSQLSchemaUpdate;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;

public class SpringSQLSchemaUpdater
extends SQLSchemaUpdater
implements BeanFactoryAware,
InitializingBean {
    private ListableBeanFactory beanFactory;

    public void afterPropertiesSet() throws Exception {
        if (this.getDatabaseInitialization() == null) {
            throw new Exception("no database initialization configured");
        }
        if (this.getUpdateTableInitialization() == null) {
            throw new Exception("no update table initialization configured");
        }
        if (this.getUpdates() == null) {
            if (this.beanFactory == null) {
                throw new IllegalArgumentException("no updates explicitly configured and the containing BeanFactory is not a ListableBeanFactory: " + String.valueOf(this.beanFactory));
            }
            this.setUpdates(this.beanFactory.getBeansOfType(SpringSQLSchemaUpdate.class).values());
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ListableBeanFactory) {
            this.beanFactory = (ListableBeanFactory)beanFactory;
        }
    }

    protected boolean indicatesUninitializedDatabase(Connection c, SQLException e) throws SQLException {
        return this.translate(e, c, null) instanceof BadSqlGrammarException;
    }

    protected void apply(Connection c, DatabaseAction<Connection> action) throws SQLException {
        try {
            super.apply(c, action);
        }
        catch (SQLException e) {
            String sql = action instanceof SQLCommand ? ((SQLCommand)action).getSQL() : null;
            throw this.translate(e, c, sql);
        }
    }

    protected DataAccessException translate(SQLException e, Connection c, String sql) throws SQLException {
        return new SQLErrorCodeSQLExceptionTranslator(c.getMetaData().getDatabaseProductName()).translate("database access during schema update", sql, e);
    }

    protected Comparator<SchemaUpdate<Connection>> getOrderingTieBreaker() {
        if (this.beanFactory == null) {
            return super.getOrderingTieBreaker();
        }
        final BeanNameComparator beanNameComparator = new BeanNameComparator(this.beanFactory);
        return new Comparator<SchemaUpdate<Connection>>(){

            @Override
            public int compare(SchemaUpdate<Connection> update1, SchemaUpdate<Connection> update2) {
                return beanNameComparator.compare(update1.getName(), update2.getName());
            }
        };
    }
}

