/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.data;

import com.google.common.base.Preconditions;
import com.vaadin.flow.data.provider.ListDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import org.dellroad.stuff.vaadin24.util.AsyncTaskManager;
import org.dellroad.stuff.vaadin24.util.VaadinUtil;

public class AsyncDataProvider<T>
extends ListDataProvider<T> {
    private final AsyncTaskManager<Stream<? extends T>> taskManager;

    public AsyncDataProvider() {
        this(new AsyncTaskManager<Stream<? extends T>>());
    }

    public AsyncDataProvider(AsyncTaskManager<Stream<? extends T>> taskManager) {
        super(new ArrayList());
        Preconditions.checkArgument((taskManager != null ? 1 : 0) != 0, (Object)"null taskManager");
        this.taskManager = taskManager;
        this.taskManager.setResultConsumer(this::updateFromLoad);
    }

    public AsyncTaskManager<Stream<? extends T>> getAsyncTaskManager() {
        return this.taskManager;
    }

    public long load(Loader<? extends T> loader) {
        Preconditions.checkArgument((loader != null ? 1 : 0) != 0, (Object)"null loader");
        return this.taskManager.startTask(id -> {
            Stream result = loader.load(id);
            if (result == null) {
                throw new IllegalArgumentException("loader returned null Stream");
            }
            return result;
        });
    }

    public long cancel() {
        return this.taskManager.cancelTask();
    }

    protected void updateFromLoad(long id, Stream<? extends T> stream) {
        VaadinUtil.assertCurrentSession(this.taskManager.getVaadinSession());
        Collection items = this.getItems();
        items.clear();
        stream.forEach(items::add);
        this.refreshAll();
    }

    @FunctionalInterface
    public static interface Loader<T> {
        public Stream<? extends T> load(long var1) throws InterruptedException;
    }
}

