/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.data;

import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.PropertyDefinition;
import com.vaadin.flow.data.binder.PropertySet;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.function.ValueProvider;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.dellroad.stuff.java.Primitive;
import org.dellroad.stuff.java.ReflectUtil;

public class SimplePropertySet<T>
implements PropertySet<T> {
    private final Map<String, Definition<?>> propertyMap = new LinkedHashMap();
    private final Class<T> targetType;

    public SimplePropertySet(Class<T> targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException("null targetType");
        }
        this.targetType = targetType;
    }

    public Stream<PropertyDefinition<T, ?>> getProperties() {
        return this.propertyMap.values().stream().map(x -> x);
    }

    public Optional<PropertyDefinition<T, ?>> getProperty(String name) {
        return Optional.ofNullable((PropertyDefinition)this.propertyMap.get(name));
    }

    public Class<T> getTargetType() {
        return this.targetType;
    }

    public <V> Definition<V> addPropertyDefinition(String name, Class<V> type, String caption, ValueProvider<? super T, ? extends V> getter, Setter<? super T, ? super V> setter) {
        Definition<? super V> newDefinition = new Definition<V>(name, type, caption, getter, setter);
        Definition<? super V> oldDefinition = this.propertyMap.putIfAbsent(name, newDefinition);
        if (oldDefinition != null) {
            throw new IllegalArgumentException("duplicate name");
        }
        return newDefinition;
    }

    public Definition<?> addPropertyDefinition(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("null propertyDescriptor");
        }
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            throw new IllegalArgumentException(IndexedPropertyDescriptor.class + " unsupported");
        }
        return this.addPropertyDefinition(propertyDescriptor.getName(), propertyDescriptor.getPropertyType(), propertyDescriptor.getDisplayName(), propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod());
    }

    private <V> Definition<V> addPropertyDefinition(String name, Class<V> type, String caption, Method getter, Method setter) {
        if (getter == null) {
            throw new IllegalArgumentException("null getter");
        }
        return this.addPropertyDefinition(name, type, caption, (ValueProvider & Serializable)target -> Primitive.wrap((Class)type).cast(ReflectUtil.invoke((Method)getter, (Object)target, (Object[])new Object[0])), setter != null ? (Setter & Serializable)(target, value) -> ReflectUtil.invoke((Method)setter, (Object)target, (Object[])new Object[]{value}) : null);
    }

    public static Definition<?> propertyDefinitionForBinding(Binder.Binding<?, ?> binding) {
        if (binding == null) {
            throw new IllegalArgumentException("null binding");
        }
        return Optional.ofNullable(binding.getGetter()).filter(Definition.Getter.class::isInstance).map(Definition.Getter.class::cast).map(Definition.Getter::getDefinition).orElseThrow(() -> new IllegalArgumentException("binding's binder does not use SimplePropertySet"));
    }

    protected <V> Definition<V> createDefinition(String name, Class<V> type, String caption, ValueProvider<? super T, ? extends V> getter, Setter<? super T, ? super V> setter) {
        return new Definition<V>(name, type, caption, getter, setter);
    }

    public class Definition<V>
    implements PropertyDefinition<T, V> {
        private final String name;
        private final Class<V> type;
        private final String caption;
        private final ValueProvider<? super T, ? extends V> getter;
        private final Setter<? super T, ? super V> setter;

        public Definition(String name, Class<V> type, String caption, ValueProvider<? super T, ? extends V> getter, Setter<? super T, ? super V> setter) {
            if (name == null) {
                throw new IllegalArgumentException("null name");
            }
            if (type == null) {
                throw new IllegalArgumentException("null type");
            }
            if (caption == null) {
                throw new IllegalArgumentException("null caption");
            }
            if (getter == null) {
                throw new IllegalArgumentException("null getter");
            }
            this.name = name;
            this.type = type;
            this.caption = caption;
            this.getter = getter;
            this.setter = setter;
        }

        public String getCaption() {
            return this.caption;
        }

        public Getter getGetter() {
            return new Getter();
        }

        public String getName() {
            return this.name;
        }

        public PropertyDefinition<T, ?> getParent() {
            return null;
        }

        public Class<T> getPropertyHolderType() {
            return SimplePropertySet.this.targetType;
        }

        public PropertySet<T> getPropertySet() {
            return SimplePropertySet.this;
        }

        public Optional<Setter<T, V>> getSetter() {
            return Optional.ofNullable(this.setter).map(s -> (arg_0, arg_1) -> ((Setter)s).accept(arg_0, arg_1));
        }

        public Class<V> getType() {
            return Primitive.wrap(this.type);
        }

        public boolean isGenericType() {
            return this.type.getTypeParameters().length > 0;
        }

        public class Getter
        implements ValueProvider<T, V> {
            public Definition<V> getDefinition() {
                return Definition.this;
            }

            public V apply(T target) {
                if (target == null) {
                    throw new IllegalArgumentException("null target");
                }
                return Definition.this.getter.apply(target);
            }
        }
    }
}

