/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.field;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.BindingValidationStatusHandler;
import com.vaadin.flow.data.binder.ErrorMessageProvider;
import com.vaadin.flow.data.binder.Validator;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.shared.util.SharedUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dellroad.stuff.java.AnnotationUtil;
import org.dellroad.stuff.java.MethodAnnotationScanner;
import org.dellroad.stuff.java.Primitive;
import org.dellroad.stuff.java.ReflectUtil;
import org.dellroad.stuff.vaadin24.field.FieldBuilderContext;
import org.dellroad.stuff.vaadin24.field.FieldComponent;
import org.dellroad.stuff.vaadin24.field.NullableField;
import org.dellroad.stuff.vaadin24.field.ValidatingField;

public abstract class AbstractFieldBuilder<S extends AbstractFieldBuilder<S, T>, T>
implements Serializable {
    public static final String DEFAULT_IMPLEMENTATION_PROPERTY_NAME = "implementation";
    public static final String DEFAULT_ANNOTATION_DEFAULTS_METHOD_NAME = "annotationDefaultsMethod";
    private static final String STRING_DEFAULT = "<FieldBuilderStringDefault>";
    private static final long serialVersionUID = -3091638771700394722L;
    private final Class<T> type;
    private transient LinkedHashMap<String, BindingInfo> bindingInfoMap;
    private transient HashMap<Class<?>, Map<String, DefaultInfo>> defaultInfoMap;
    private LinkedHashMap<String, FieldComponent<?>> fieldComponentMap;

    protected AbstractFieldBuilder(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        this.type = type;
        this.scanForAnnotations();
    }

    protected AbstractFieldBuilder(AbstractFieldBuilder<S, T> original) {
        if (original == null) {
            throw new IllegalArgumentException("null original");
        }
        this.type = original.type;
        this.bindingInfoMap = new LinkedHashMap<String, BindingInfo>(original.bindingInfoMap);
        this.defaultInfoMap = new HashMap(original.defaultInfoMap);
    }

    public Class<T> getType() {
        return this.type;
    }

    public Map<String, BindingInfo> getScannedProperties() {
        return Collections.unmodifiableMap(this.bindingInfoMap);
    }

    public Map<Class<?>, Map<String, DefaultInfo>> getScannedFieldDefaults() {
        return Collections.unmodifiableMap(this.defaultInfoMap);
    }

    public void bindFields(Binder<? extends T> binder) {
        if (binder == null) {
            throw new IllegalArgumentException("null binder");
        }
        this.fieldComponentMap = new LinkedHashMap();
        this.bindingInfoMap.forEach((propertyName, info) -> {
            FieldComponent<?> fieldComponent = info.createFieldComponent(binder.getBean());
            info.bind(binder, fieldComponent.getField());
            this.fieldComponentMap.put((String)propertyName, fieldComponent);
        });
        this.bindingInfoMap.forEach((name, info) -> this.configureEnabledBy(binder, (String)name, (BindingInfo)info));
    }

    private <V> void configureEnabledBy(Binder<? extends T> binder, String targetFieldName, BindingInfo targetFieldInfo) {
        HasEnabled targetField;
        EnabledBy enabledBy = targetFieldInfo.getEnabledBy();
        if (enabledBy == null) {
            return;
        }
        boolean requireAll = enabledBy.requireAll();
        boolean resetOnDisable = enabledBy.resetOnDisable();
        HasValue<?, ?> targetField0 = this.fieldComponentMap.get(targetFieldName).getField();
        try {
            targetField = (HasEnabled)targetField0;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("field \"%s\" has @EnabledBy annotation but its type %s does not implement %s", targetFieldName, targetField0.getClass().getName(), HasEnabled.class.getName()), e);
        }
        String[] controllingFieldNames = enabledBy.value();
        if (controllingFieldNames.length == 0) {
            return;
        }
        class ControllingField {
            final HasValue<?, ?> field;
            final String nullRepresentation;
            final AtomicReference<Object> currentValue;

            ControllingField(HasValue<?, ?> field, String nullRepresentation) {
                this.field = field;
                this.nullRepresentation = nullRepresentation;
                this.currentValue = new AtomicReference<Object>(this.field.getValue());
            }

            HasValue<?, ?> getField() {
                return this.field;
            }

            AtomicReference<Object> currentValue() {
                return this.currentValue;
            }

            boolean isEnabling() {
                Object value = this.currentValue.get();
                return !Objects.equals(value, this.field.getEmptyValue()) && (this.nullRepresentation == null || !Objects.equals(value, this.nullRepresentation));
            }
        }
        List<ControllingField> controllingFields = Stream.of(controllingFieldNames).map(name -> {
            Binder.Binding<T, ?> binding = this.findControllingFieldBinding(binder, targetFieldName, (String)name);
            String nullRepresentation = Optional.of(this.bindingInfoMap.get(name)).map(BindingInfo::getBinding).map(Binding::nullRepresentation).filter(string -> !STRING_DEFAULT.equals(string)).orElse(null);
            return new ControllingField(binding.getField(), nullRepresentation);
        }).collect(Collectors.toList());
        Runnable updateTargetFieldEnablement = () -> {
            boolean enableTargetField;
            boolean bl = enableTargetField = requireAll ? controllingFields.stream().allMatch(ControllingField::isEnabling) : controllingFields.stream().anyMatch(ControllingField::isEnabling);
            if (targetField.isEnabled() == enableTargetField) {
                return;
            }
            if (!enableTargetField && resetOnDisable) {
                this.resetField(targetField0);
            }
            targetField.setEnabled(enableTargetField);
        };
        updateTargetFieldEnablement.run();
        controllingFields.forEach(controllingField -> controllingField.getField().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            controllingField.currentValue().set(e.getValue());
            updateTargetFieldEnablement.run();
        }));
    }

    private Binder.Binding<? extends T, ?> findControllingFieldBinding(Binder<? extends T> binder, String targetFieldName, String controllingFieldName) {
        return (Binder.Binding)binder.getBinding(controllingFieldName).orElseThrow(() -> new IllegalArgumentException(String.format("field \"%s\" is @EnabledBy unknown field \"%s\"", targetFieldName, controllingFieldName)));
    }

    private <V> void resetField(HasValue<?, V> field) {
        field.setValue(field.getEmptyValue());
    }

    public Map<String, FieldComponent<?>> getFieldComponents() {
        if (this.fieldComponentMap == null) {
            throw new IllegalStateException("bindFields() must be invoked first");
        }
        return Collections.unmodifiableMap(this.fieldComponentMap);
    }

    public void addFieldComponents(com.vaadin.flow.component.formlayout.FormLayout formLayout) {
        if (formLayout == null) {
            throw new IllegalArgumentException("null formLayout");
        }
        if (this.fieldComponentMap == null) {
            throw new IllegalStateException("bindFields() must be invoked first");
        }
        this.bindingInfoMap.forEach((propertyName, info) -> info.addField(formLayout, this.fieldComponentMap.get(propertyName).getComponent()));
    }

    protected void scanForAnnotations() {
        this.bindingInfoMap = new LinkedHashMap();
        this.defaultInfoMap = new HashMap();
        HashMap bindingAnnotationMap = new HashMap();
        this.findAnnotatedMethods(Binding.class).forEach(methodInfo -> {
            String propertyName = ReflectUtil.propertyNameFromGetterMethod((Method)methodInfo.getMethod());
            if (propertyName != null) {
                bindingAnnotationMap.put(propertyName, (Binding)methodInfo.getAnnotation());
            }
        });
        HashMap formLayoutAnnotationMap = new HashMap();
        this.findAnnotatedMethods(FormLayout.class).forEach(methodInfo -> {
            String propertyName = ReflectUtil.propertyNameFromGetterMethod((Method)methodInfo.getMethod());
            if (propertyName != null) {
                formLayoutAnnotationMap.put(propertyName, (FormLayout)methodInfo.getAnnotation());
            }
        });
        this.getDeclarativeAnnotationTypes().forEach(annotationType -> {
            Set<MethodAnnotationScanner.MethodInfo> methodInfos = this.findAnnotatedMethods((Class)annotationType);
            for (MethodAnnotationScanner.MethodInfo methodInfo : methodInfos) {
                Method method = methodInfo.getMethod();
                String propertyName = ReflectUtil.propertyNameFromGetterMethod((Method)method);
                if (propertyName == null) {
                    throw new IllegalArgumentException("invalid @" + annotationType.getSimpleName() + " annotation on non-getter method " + method.getName());
                }
                NullifyCheckbox nullifyCheckbox = method.getAnnotation(NullifyCheckbox.class);
                EnabledBy enabledBy = method.getAnnotation(EnabledBy.class);
                BindingInfo bindingInfo = this.createBindingInfo(method, propertyName, methodInfo.getAnnotation(), (Binding)bindingAnnotationMap.get(propertyName), (FormLayout)formLayoutAnnotationMap.get(propertyName), nullifyCheckbox, enabledBy, (info, bean) -> this.buildDeclarativeField((BindingInfo)info));
                BindingInfo previousInfo = this.bindingInfoMap.putIfAbsent(propertyName, bindingInfo);
                if (previousInfo == null) continue;
                throw new IllegalArgumentException(String.format("conflicting annotations for property \"%s\": %s and %s", propertyName, previousInfo.getOrigin(), bindingInfo.getOrigin()));
            }
        });
        this.bindingInfoMap.values().stream().filter(info -> !(info.getAnnotation() instanceof ProvidesField)).map(this::newFieldBuilderContext).map(FieldBuilderContext::inferDataModelType).distinct().forEach(modelType -> {
            Map<String, DefaultInfo> defaultInfo = this.scanForFieldDefaultAnnotations((Class)modelType);
            if (!defaultInfo.isEmpty()) {
                this.defaultInfoMap.put((Class<?>)modelType, defaultInfo);
            }
        });
        new MethodAnnotationScanner<T, ProvidesField>(this.type, ProvidesField.class){

            protected boolean includeMethod(Method method, ProvidesField annotation) {
                Class<?> returnType = method.getReturnType();
                if (!(HasValue.class.isAssignableFrom(returnType) && Component.class.isAssignableFrom(returnType) || FieldComponent.class.isAssignableFrom(returnType))) {
                    throw new IllegalArgumentException("incompatible return type for @ProvidesField annotation on method " + method);
                }
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (!(parameterTypes.length == 0 || parameterTypes.length == 1 && FieldBuilderContext.class.isAssignableFrom(parameterTypes[0]))) {
                    throw new IllegalArgumentException("incompatible parameter type(s) for @ProvidesField annotation on method " + method);
                }
                return true;
            }
        }.findAnnotatedMethods().forEach(methodInfo -> {
            Method method = methodInfo.getMethod();
            ProvidesField providesField = (ProvidesField)methodInfo.getAnnotation();
            String propertyName = providesField.value();
            if (!FieldComponent.class.isAssignableFrom(method.getReturnType())) {
                Stream.of(HasValue.class, Component.class).forEach(requiredType -> {
                    if (!requiredType.isAssignableFrom(method.getReturnType())) {
                        throw new IllegalArgumentException(String.format("invalid @%s annotation on method %s: return type %s is not a sub-type of %s", ProvidesField.class.getName(), method, method.getReturnType().getName(), requiredType.getName()));
                    }
                });
            }
            NullifyCheckbox nullifyCheckbox = method.getAnnotation(NullifyCheckbox.class);
            EnabledBy enabledBy = method.getAnnotation(EnabledBy.class);
            BindingInfo bindingInfo = this.createBindingInfo(method, propertyName, providesField, (Binding)bindingAnnotationMap.get(propertyName), (FormLayout)formLayoutAnnotationMap.get(propertyName), nullifyCheckbox, enabledBy, (info, bean) -> this.buildProvidedField((BindingInfo)info, (MethodAnnotationScanner.MethodInfo)methodInfo, bean));
            BindingInfo previousInfo = this.bindingInfoMap.putIfAbsent(propertyName, bindingInfo);
            if (previousInfo != null) {
                throw new IllegalArgumentException(String.format("conflicting annotations for property \"%s\": %s and %s", propertyName, previousInfo.getOrigin(), bindingInfo.getOrigin()));
            }
        });
        Comparator<Map.Entry> comparator = Comparator.comparingDouble(entry -> ((BindingInfo)entry.getValue()).getSortOrder()).thenComparing(Map.Entry::getKey);
        ArrayList<Map.Entry<String, BindingInfo>> infoList = new ArrayList<Map.Entry<String, BindingInfo>>(this.bindingInfoMap.entrySet());
        infoList.sort(comparator);
        this.bindingInfoMap.clear();
        infoList.forEach((Consumer<Map.Entry<String, BindingInfo>>)((Consumer<Map.Entry>)entry -> this.bindingInfoMap.put((String)entry.getKey(), (BindingInfo)entry.getValue())));
    }

    protected <M> Map<String, DefaultInfo> scanForFieldDefaultAnnotations(Class<M> modelType) {
        if (modelType == null) {
            throw new IllegalArgumentException("null modelType");
        }
        HashMap defaultMap = new HashMap();
        new MethodAnnotationScanner<M, FieldDefault>(modelType, FieldDefault.class){

            protected boolean includeMethod(Method method, FieldDefault annotation) {
                return super.includeMethod(method, (Annotation)annotation) && (method.getModifiers() & 8) != 0;
            }
        }.findAnnotatedMethods().forEach(methodInfo -> {
            Method method = methodInfo.getMethod();
            FieldDefault defaultAnnotation = (FieldDefault)methodInfo.getAnnotation();
            String propertyName = defaultAnnotation.value();
            defaultMap.merge(propertyName, new DefaultInfo(method, propertyName), (info1, info2) -> {
                int diff = ReflectUtil.getClassComparator().compare(info1.getMethod().getDeclaringClass(), info2.getMethod().getDeclaringClass());
                if (diff < 0) {
                    return info1;
                }
                if (diff > 0) {
                    return info2;
                }
                throw new IllegalArgumentException(String.format("conflicting @%s annotations for field property \"%s\" on methods %s and %s", FieldDefault.class.getName(), propertyName, info1.getMethod(), info2.getMethod()));
            });
        });
        return Collections.unmodifiableMap(defaultMap);
    }

    private <A extends Annotation> Set<MethodAnnotationScanner.MethodInfo> findAnnotatedMethods(Class<A> annotationType) {
        return new MethodAnnotationScanner(this.type, annotationType).findAnnotatedMethods();
    }

    private Method workAroundIntrospectorBug(Method method) {
        if (method == null) {
            return method;
        }
        for (Class<T> c = this.type; c != null && c != method.getClass(); c = c.getSuperclass()) {
            try {
                method = c.getDeclaredMethod(method.getName(), method.getParameterTypes());
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
        return method;
    }

    protected FieldComponent<?> buildDeclarativeField(BindingInfo bindingInfo) {
        if (bindingInfo == null) {
            throw new IllegalArgumentException("null bindingInfo");
        }
        Annotation annotation = bindingInfo.getAnnotation();
        AnnotationApplier applier = new AnnotationApplier(this, bindingInfo, this.getDefaultsFor(annotation));
        HasValue<?, ?> field = applier.createField();
        if (!(field instanceof Component)) {
            throw new RuntimeException("internal error: field type generated from @" + annotation.annotationType().getName() + " annotation on method " + bindingInfo.getMethod() + " is not a sub-type of " + Component.class);
        }
        this.applyFieldDefaultAnnotations(field, this.newFieldBuilderContext(bindingInfo).inferDataModelType());
        applier.configureField(field);
        return new FieldComponent(field, (Component)field);
    }

    protected void applyFieldDefaultAnnotations(HasValue<?, ?> field, Class<?> modelType) {
        if (field == null) {
            throw new IllegalArgumentException("null field");
        }
        if (modelType == null) {
            throw new IllegalArgumentException("null modelType");
        }
        this.defaultInfoMap.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(modelType)).reduce(BinaryOperator.minBy(Map.Entry.comparingByKey(ReflectUtil.getClassComparator()))).map(Map.Entry::getValue).map(Map::values).map(Collection::stream).ifPresent(stream -> stream.forEach(info -> info.applyTo(field)));
    }

    protected FieldComponent<?> buildProvidedField(BindingInfo bindingInfo, MethodAnnotationScanner.MethodInfo methodInfo, Object bean) {
        if (bindingInfo == null) {
            throw new IllegalArgumentException("null bindingInfo");
        }
        if (methodInfo == null) {
            throw new IllegalArgumentException("null methodInfo");
        }
        Method method = methodInfo.getMethod();
        if ((method.getModifiers() & 8) != 0) {
            bean = null;
        } else if ((method.getModifiers() & 8) == 0 && bean == null) {
            throw new IllegalArgumentException("@" + ProvidesField.class.getName() + " annotated method " + method + " is an instance method but the Binder has no bound bean");
        }
        try {
            method.setAccessible(true);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            Object field;
            Object object = field = method.getParameterTypes().length > 0 ? method.invoke(bean, this.newFieldBuilderContext(bindingInfo)) : method.invoke(bean, new Object[0]);
            if (field == null) {
                throw new IllegalArgumentException("null value returned");
            }
            if (field instanceof FieldComponent) {
                return (FieldComponent)field;
            }
            return new FieldComponent((HasValue)field, (Component)field);
        }
        catch (Exception e) {
            throw new RuntimeException("error invoking @" + ProvidesField.class.getName() + " annotated method " + method, e);
        }
    }

    protected <A extends Annotation> A getDefaultsFor(A annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("null annotation");
        }
        return (A)this.getDefaultsFor(annotation.annotationType());
    }

    protected <A extends Annotation> A getDefaultsFor(Class<A> annotationType) {
        if (annotationType == null) {
            throw new IllegalArgumentException("null annotationType");
        }
        return (A)((Annotation)Optional.ofNullable(this.getAnnotationDefaultsMethod().getAnnotation(annotationType)).orElseThrow(() -> new IllegalArgumentException(annotationType + " is not a defined widget annotation type")));
    }

    protected Stream<Class<? extends Annotation>> getDeclarativeAnnotationTypes() {
        return ((List)ReflectUtil.invoke((Method)this.getAnnotationDefaultsMethod(), null, (Object[])new Object[0])).stream();
    }

    protected BindingInfo createBindingInfo(Method method, String propertyName, Annotation annotation, Binding binding, FormLayout formLayout, NullifyCheckbox nullifyCheckbox, EnabledBy enabledBy, BiFunction<BindingInfo, ? super T, FieldComponent<?>> fieldBuilder) {
        return new BindingInfo(method, propertyName, annotation, binding, formLayout, nullifyCheckbox, enabledBy, fieldBuilder);
    }

    protected Method getAnnotationDefaultsMethod() {
        Method method = null;
        for (Class<?> stype = this.getClass(); stype != null; stype = stype.getSuperclass()) {
            try {
                method = stype.getDeclaredMethod(this.getAnnotationDefaultsMethodName(), new Class[0]);
                break;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        if (method == null) {
            throw new RuntimeException("internal error: method " + this.getAnnotationDefaultsMethodName() + "() not found");
        }
        try {
            method.setAccessible(true);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return method;
    }

    protected String getAnnotationDefaultsMethodName() {
        return DEFAULT_ANNOTATION_DEFAULTS_METHOD_NAME;
    }

    protected String getImplementationPropertyName() {
        return DEFAULT_IMPLEMENTATION_PROPERTY_NAME;
    }

    protected <F> F instantiate(Class<F> expectedType, BindingInfo bindingInfo, Annotation annotation, String propertyName) {
        Class<F> implType;
        if (expectedType == null) {
            throw new IllegalArgumentException("null expectedType");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("null annotation");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("null propertyName");
        }
        try {
            implType = ((Class)annotation.annotationType().getMethod(propertyName, new Class[0]).invoke((Object)annotation, new Object[0])).asSubclass(expectedType);
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected exception", e);
        }
        return this.instantiate(implType, bindingInfo);
    }

    protected <T> T instantiate(Class<T> type, BindingInfo bindingInfo) {
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        if (bindingInfo == null) {
            throw new IllegalArgumentException("null bindingInfo");
        }
        FieldBuilderContext context = this.newFieldBuilderContext(bindingInfo);
        Function<Supplier, Object> errorWrapper = invoker -> {
            try {
                return invoker.get();
            }
            catch (RuntimeException e) {
                throw new RuntimeException("error instantiating " + type.getName() + " for " + bindingInfo.getOrigin(), e);
            }
        };
        return type.cast(Stream.of(type.getConstructors()).filter(c -> c.getParameterCount() == 1).filter(c -> c.getParameterTypes()[0].isInstance(context)).min(Comparator.comparing(c -> c.getParameterTypes()[0], ReflectUtil.getClassComparator())).map(constructor -> errorWrapper.apply(() -> ReflectUtil.instantiate((Constructor)constructor, (Object[])new Object[]{context}))).orElseGet(() -> errorWrapper.apply(() -> ReflectUtil.instantiate((Class)type))));
    }

    protected FieldBuilderContext newFieldBuilderContext(BindingInfo bindingInfo) {
        return new FieldBuilderContextImpl(bindingInfo);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.scanForAnnotations();
    }

    public class BindingInfo {
        private final Method method;
        private final String propertyName;
        private final Annotation annotation;
        private final Binding binding;
        private final FormLayout formLayout;
        private final NullifyCheckbox nullifyCheckbox;
        private final EnabledBy enabledBy;
        private final BiFunction<BindingInfo, ? super T, FieldComponent<?>> fieldBuilder;

        public BindingInfo(Method method, String propertyName, Annotation annotation, Binding binding, FormLayout formLayout, NullifyCheckbox nullifyCheckbox, EnabledBy enabledBy, BiFunction<BindingInfo, ? super T, FieldComponent<?>> fieldBuilder) {
            if (method == null) {
                throw new IllegalArgumentException("null method");
            }
            if (propertyName == null) {
                throw new IllegalArgumentException("null propertyName");
            }
            if (annotation == null) {
                throw new IllegalArgumentException("null annotation");
            }
            if (fieldBuilder == null) {
                throw new IllegalArgumentException("null fieldBuilder");
            }
            this.method = method;
            this.propertyName = propertyName;
            this.annotation = annotation;
            this.binding = binding;
            this.formLayout = formLayout;
            this.nullifyCheckbox = nullifyCheckbox;
            this.enabledBy = enabledBy;
            this.fieldBuilder = fieldBuilder;
        }

        public AbstractFieldBuilder<S, T> getFieldBuilder() {
            return AbstractFieldBuilder.this;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public Binding getBinding() {
            return this.binding;
        }

        public FormLayout getFormLayout() {
            return this.formLayout;
        }

        public NullifyCheckbox getNullifyCheckbox() {
            return this.nullifyCheckbox;
        }

        public EnabledBy getEnabledBy() {
            return this.enabledBy;
        }

        public double getSortOrder() {
            return Optional.ofNullable(this.formLayout).map(FormLayout::order).orElse(0.0);
        }

        public String getOrigin() {
            return String.format("@%s on method %s", this.annotation.annotationType().getName(), this.method);
        }

        protected <T> T instantiate(Class<T> type) {
            return AbstractFieldBuilder.this.instantiate(type, this);
        }

        public FieldComponent<?> createFieldComponent(T bean) {
            FieldComponent<?> fieldComponent = this.fieldBuilder.apply(this, (BindingInfo)bean);
            if (this.nullifyCheckbox != null) {
                fieldComponent = this.addNullifyCheckbox(fieldComponent);
            }
            return fieldComponent;
        }

        protected <T> FieldComponent<T> addNullifyCheckbox(FieldComponent<T> fieldComponent) {
            if (fieldComponent == null) {
                throw new IllegalArgumentException("null fieldComponent");
            }
            if (this.nullifyCheckbox == null) {
                throw new IllegalStateException("no nullifyCheckbox");
            }
            NullableField<T> field = new NullableField<T>(fieldComponent.getField(), fieldComponent.getComponent(), (HasValue<?, Boolean>)new Checkbox(this.nullifyCheckbox.value()));
            field.setDisplayErrorMessages(this.nullifyCheckbox.displayErrorMessages());
            field.setResetOnDisable(this.nullifyCheckbox.resetOnDisable());
            return new FieldComponent(field);
        }

        public <V> Binder.Binding<? extends T, ?> bind(Binder<? extends T> binder, HasValue<?, V> field) {
            if (binder == null) {
                throw new IllegalArgumentException("null binder");
            }
            if (field == null) {
                throw new IllegalArgumentException("null field");
            }
            Binder.BindingBuilder bindingBuilder = binder.forField(field);
            if (field instanceof ValidatingField) {
                ValidatingField validatingField = (ValidatingField)field;
                bindingBuilder = validatingField.addValidationTo(bindingBuilder);
            }
            if (this.binding != null) {
                if (this.binding.requiredValidator() != Validator.class) {
                    bindingBuilder = bindingBuilder.asRequired(this.instantiate(this.binding.requiredValidator()));
                } else if (this.binding.requiredProvider() != ErrorMessageProvider.class) {
                    bindingBuilder = bindingBuilder.asRequired(this.instantiate(this.binding.requiredProvider()));
                } else if (this.binding.required().length() > 0) {
                    bindingBuilder = bindingBuilder.asRequired(this.binding.required());
                }
                if (!this.binding.nullRepresentation().equals(AbstractFieldBuilder.STRING_DEFAULT)) {
                    bindingBuilder = bindingBuilder.withNullRepresentation((Object)this.binding.nullRepresentation());
                }
                if (this.binding.converter() != Converter.class) {
                    bindingBuilder = bindingBuilder.withConverter(this.instantiate(this.binding.converter()));
                }
                for (Class<? extends Validator> validatorClass : this.binding.validators()) {
                    bindingBuilder = bindingBuilder.withValidator(this.instantiate(validatorClass));
                }
                if (this.binding.postValidationConverter() != Converter.class) {
                    bindingBuilder = bindingBuilder.withConverter(this.instantiate(this.binding.postValidationConverter()));
                }
                if (this.binding.validationStatusHandler() != BindingValidationStatusHandler.class) {
                    bindingBuilder = bindingBuilder.withValidationStatusHandler(this.instantiate(this.binding.validationStatusHandler()));
                }
            }
            return bindingBuilder.bind(this.propertyName);
        }

        public void addField(com.vaadin.flow.component.formlayout.FormLayout formLayout, Component component) {
            if (formLayout == null) {
                throw new IllegalArgumentException("null formLayout");
            }
            if (component == null) {
                throw new IllegalArgumentException("null component");
            }
            String label = Optional.ofNullable(this.formLayout).map(FormLayout::label).filter(value -> !value.isEmpty()).orElse(null);
            if (label == null) {
                label = component instanceof Checkbox || component instanceof NullableField ? "" : Optional.ofNullable(this.getLabel(component)).orElseGet(() -> SharedUtil.camelCaseToHumanFriendly((String)this.propertyName));
            }
            FormLayout.FormItem formItem = formLayout.addFormItem(component, label);
            Optional.ofNullable(this.formLayout).map(FormLayout::colspan).filter(colspan -> colspan > 0).ifPresent(colspan -> formLayout.setColspan((Component)formItem, colspan.intValue()));
        }

        protected String getLabel(Object obj) {
            try {
                return (String)obj.getClass().getMethod("getLabel", new Class[0]).invoke(obj, new Object[0]);
            }
            catch (ClassCastException | IllegalArgumentException | ReflectiveOperationException e) {
                return null;
            }
        }

        public String toString() {
            return String.format("%s[property=\"%s\",method=%s,annotation=@%s]", this.getClass().getSimpleName(), this.getPropertyName(), this.getMethod(), this.getAnnotation().annotationType().getSimpleName());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface EnabledBy {
        public String[] value() default {};

        public boolean resetOnDisable() default true;

        public boolean requireAll() default true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface Binding {
        public String required() default "";

        public Class<? extends ErrorMessageProvider> requiredProvider() default ErrorMessageProvider.class;

        public Class<? extends Validator> requiredValidator() default Validator.class;

        public Class<? extends Converter> converter() default Converter.class;

        public Class<? extends Converter> postValidationConverter() default Converter.class;

        public String nullRepresentation() default "<FieldBuilderStringDefault>";

        public Class<? extends BindingValidationStatusHandler> validationStatusHandler() default BindingValidationStatusHandler.class;

        public Class<? extends Validator>[] validators() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface FormLayout {
        public int colspan() default 0;

        public String label() default "";

        public double order() default 0.0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface ProvidesField {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface FieldDefault {
        public String value();
    }

    private static class AnnotationApplier<A extends Annotation> {
        protected final BindingInfo bindingInfo;
        protected final A defaults;
        protected final Method stylePropertiesMethod;
        final /* synthetic */ AbstractFieldBuilder this$0;

        AnnotationApplier(BindingInfo bindingInfo, A defaults) {
            this.this$0 = var1_1;
            if (bindingInfo == null) {
                throw new IllegalArgumentException("null bindingInfo");
            }
            if (defaults == null) {
                throw new IllegalArgumentException("null defaults");
            }
            this.bindingInfo = bindingInfo;
            this.defaults = defaults;
            Method method = null;
            try {
                method = this.bindingInfo.getAnnotation().getClass().getMethod("styleProperties", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.stylePropertiesMethod = method;
        }

        public HasValue<?, ?> createField() {
            return this.this$0.instantiate(HasValue.class, this.bindingInfo, this.bindingInfo.getAnnotation(), this.this$0.getImplementationPropertyName());
        }

        public void configureField(HasValue<?, ?> field) {
            AnnotationUtil.applyAnnotationValues(field, (String)"set", (Annotation)this.bindingInfo.getAnnotation(), this.defaults, (methodList, propertyName) -> propertyName, this::instantiate);
            AnnotationUtil.applyAnnotationValues(field, (String)"add", (Annotation)this.bindingInfo.getAnnotation(), this.defaults, (methodList, propertyName) -> ((Method)methodList.get(0)).getName(), this::instantiate);
            this.configureFieldCustom(field);
        }

        protected void configureFieldCustom(HasValue<?, ?> field) {
            if (this.stylePropertiesMethod != null && field instanceof HasStyle) {
                String[] styleProperties = null;
                try {
                    styleProperties = (String[])this.stylePropertiesMethod.invoke((Object)this.bindingInfo.getAnnotation(), new Object[0]);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
                if (styleProperties != null) {
                    Style style = ((HasStyle)field).getStyle();
                    int i = 0;
                    while (i < styleProperties.length - 1) {
                        style.set(styleProperties[i++], styleProperties[i++]);
                    }
                }
            }
        }

        public <T> T instantiate(Class<T> type) {
            return this.this$0.instantiate(type, this.bindingInfo);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface NullifyCheckbox {
        public String value();

        public boolean resetOnDisable() default true;

        public boolean displayErrorMessages() default true;
    }

    protected class FieldBuilderContextImpl
    implements FieldBuilderContext {
        private static final long serialVersionUID = -4636811655407064538L;
        protected final BindingInfo bindingInfo;

        public FieldBuilderContextImpl(BindingInfo bindingInfo) {
            if (bindingInfo == null) {
                throw new IllegalArgumentException("null bindingInfo");
            }
            this.bindingInfo = bindingInfo;
        }

        @Override
        public BindingInfo getBindingInfo() {
            return this.bindingInfo;
        }

        @Override
        public Class<?> getBeanType() {
            return AbstractFieldBuilder.this.type;
        }

        public String toString() {
            return String.format("%s[info=%s,beanType=%s]", this.getClass().getSimpleName(), this.getBindingInfo(), this.getBeanType());
        }
    }

    public static class DefaultInfo {
        private Method method;
        private String propertyName;

        public DefaultInfo(Method method, String propertyName) {
            if (method == null) {
                throw new IllegalArgumentException("null method");
            }
            if (propertyName == null) {
                throw new IllegalArgumentException("null propertyName");
            }
            this.method = method;
            this.propertyName = propertyName;
        }

        public Method getMethod() {
            return this.method;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean applyTo(HasValue<?, ?> field) {
            Object defaultValue;
            if (field == null) {
                throw new IllegalArgumentException("null field");
            }
            if (this.propertyName.isEmpty()) {
                return false;
            }
            try {
                this.method.setAccessible(true);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                defaultValue = this.method.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                return false;
            }
            if (defaultValue == null) {
                return false;
            }
            String methodName = "set" + this.propertyName.substring(0, 1).toUpperCase() + this.propertyName.substring(1);
            Method setter = Stream.of(field.getClass().getMethods()).filter(method -> method.getName().equals(methodName)).filter(method -> (method.getModifiers() & 8) == 0).filter(method -> method.getParameterTypes().length == 1).filter(method -> Primitive.wrap(method.getParameterTypes()[0]).isInstance(defaultValue)).reduce(BinaryOperator.minBy(Comparator.comparing(method -> Primitive.unwrap(method.getParameterTypes()[0]), ReflectUtil.getClassComparator()))).orElse(null);
            if (setter == null) {
                return false;
            }
            try {
                setter.invoke(field, defaultValue);
            }
            catch (ReflectiveOperationException e) {
                return false;
            }
            return true;
        }

        public String toString() {
            return String.format("%s[property=\"%s\",method=%s]", this.getClass().getSimpleName(), this.getPropertyName(), this.getMethod());
        }
    }
}

