/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.field;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.stream.Stream;
import org.dellroad.stuff.java.AnnotationUtil;
import org.dellroad.stuff.vaadin24.field.AbstractFieldBuilder;
import org.dellroad.stuff.vaadin24.field.FieldComponent;
import org.dellroad.stuff.vaadin24.grid.GridColumn;
import org.dellroad.stuff.vaadin24.grid.GridColumnScanner;

public class AbstractGridFieldBuilder<S extends AbstractGridFieldBuilder<S, T>, T>
extends AbstractFieldBuilder<S, T> {
    private static final long serialVersionUID = -4639701993755627170L;

    protected AbstractGridFieldBuilder(Class<T> type) {
        super(type);
    }

    protected AbstractGridFieldBuilder(AbstractGridFieldBuilder<S, T> original) {
        super(original);
    }

    @Override
    protected Stream<Class<? extends Annotation>> getDeclarativeAnnotationTypes() {
        return Stream.concat(super.getDeclarativeAnnotationTypes(), Stream.of(GridSingleSelect.class, GridMultiSelect.class));
    }

    @Override
    protected FieldComponent<?> buildDeclarativeField(AbstractFieldBuilder.BindingInfo bindingInfo) {
        if (bindingInfo == null) {
            throw new IllegalArgumentException("null bindingInfo");
        }
        Annotation annotation = bindingInfo.getAnnotation();
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (annotationType.equals(GridSingleSelect.class)) {
            Grid<?> grid = this.buildGrid(bindingInfo, ((GridMultiSelect)annotation).column());
            grid.setSelectionMode(Grid.SelectionMode.SINGLE);
            return new FieldComponent(grid.asSingleSelect(), (Component)grid);
        }
        if (annotationType.equals(GridMultiSelect.class)) {
            Grid<?> grid = this.buildGrid(bindingInfo, ((GridMultiSelect)annotation).column());
            grid.setSelectionMode(Grid.SelectionMode.MULTI);
            return new FieldComponent(grid.asMultiSelect(), (Component)grid);
        }
        return super.buildDeclarativeField(bindingInfo);
    }

    protected Grid<?> buildGrid(AbstractFieldBuilder.BindingInfo bindingInfo, GridColumn column) {
        Class<?> modelType = this.newFieldBuilderContext(bindingInfo).inferDataModelType();
        Grid grid = new Grid(modelType, false);
        Function<Class, Object> instantiator = cl -> this.instantiate(cl, bindingInfo);
        Method method = bindingInfo.getMethod();
        Annotation annotation = bindingInfo.getAnnotation();
        Class<? extends Annotation> annotationType = annotation.annotationType();
        AnnotationUtil.applyAnnotationValues((Object)grid, (String)"set", (Annotation)annotation, null, (methodList, propertyName) -> propertyName, instantiator);
        AnnotationUtil.applyAnnotationValues((Object)grid, (String)"add", (Annotation)annotation, null, (methodList, propertyName) -> ((Method)methodList.get(0)).getName(), instantiator);
        String key = !column.key().isEmpty() ? column.key() : "key";
        String description = "@" + annotationType.getSimpleName() + ".column() on method " + method;
        GridColumnScanner.addColumn(grid, key, column, description, (ValueProvider & Serializable)v -> v, false);
        return grid;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface GridSingleSelect {
        public String[] addClassNames() default {};

        public GridVariant[] addThemeVariants() default {};

        public GridColumn column() default @GridColumn;

        public Class<? extends DataProvider> items() default DataProvider.class;

        public boolean enabled() default true;

        public String height() default "";

        public String id() default "";

        public String maxHeight() default "";

        public String maxWidth() default "";

        public String minHeight() default "";

        public String minWidth() default "";

        public int pageSize() default 50;

        public boolean readOnly() default false;

        public boolean requiredIndicatorVisible() default false;

        public int tabIndex() default 0;

        public boolean visible() default true;

        public String width() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Documented
    public static @interface GridMultiSelect {
        public String[] addClassNames() default {};

        public GridVariant[] addThemeVariants() default {};

        public GridColumn column() default @GridColumn;

        public Class<? extends DataProvider> items() default DataProvider.class;

        public boolean enabled() default true;

        public String height() default "";

        public String id() default "";

        public String maxHeight() default "";

        public String maxWidth() default "";

        public String minHeight() default "";

        public String minWidth() default "";

        public int pageSize() default 50;

        public boolean readOnly() default false;

        public boolean requiredIndicatorVisible() default false;

        public int tabIndex() default 0;

        public boolean visible() default true;

        public String width() default "";
    }
}

