/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.field;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.StatusChangeListener;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValueContext;
import java.io.Serializable;
import java.util.Objects;
import org.dellroad.stuff.vaadin24.field.ValidatingField;

public abstract class BinderCustomField<T>
extends CustomField<T>
implements ValidatingField<AbstractField.ComponentValueChangeEvent<CustomField<T>, T>, T> {
    protected final Class<T> modelType;
    protected final Binder<T> binder;
    protected boolean subfieldValidationErrors;
    private InitState initState = InitState.INITIAL;
    private T initialValue;

    public BinderCustomField(Class<T> modelType) {
        if (modelType == null) {
            throw new IllegalArgumentException("null modelType");
        }
        this.modelType = modelType;
        this.binder = this.createBinder();
        this.initialize();
        this.binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.updateValue());
        this.binder.addStatusChangeListener((StatusChangeListener & Serializable)e -> {
            this.subfieldValidationErrors = e.hasValidationErrors();
            if (this.subfieldValidationErrors) {
                this.setErrorMessage(null);
            }
        });
    }

    protected void initialize() {
        if (this.initState.equals((Object)InitState.INITIALIZED)) {
            throw new IllegalStateException("duplicate initialization");
        }
        this.createAndBindFields();
        this.layoutComponents();
        boolean hasInitialValue = this.initState.equals((Object)InitState.INITIAL_VALUE);
        this.initState = InitState.INITIALIZED;
        if (hasInitialValue) {
            this.setPresentationValue(this.initialValue);
            this.initialValue = null;
        }
    }

    protected Binder<T> createBinder() {
        return new Binder(this.modelType);
    }

    protected abstract void createAndBindFields();

    protected void layoutComponents() {
        HorizontalLayout layout = new HorizontalLayout();
        this.add(new Component[]{layout});
        this.binder.getFields().map(Component.class::cast).forEach(xva$0 -> layout.add(new Component[]{xva$0}));
    }

    protected T createNewBean() {
        try {
            return this.modelType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("unexpected error invoking " + this.modelType + " constructor", e);
        }
    }

    @Override
    public ValidationResult validate(T value, ValueContext ctx) {
        return ValidationResult.ok();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.updateValue();
        } else {
            this.binder.getFields().filter(HasValidation.class::isInstance).map(HasValidation.class::cast).forEach(field -> {
                field.setInvalid(false);
                field.setErrorMessage(null);
            });
        }
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage == null || !this.subfieldValidationErrors) {
            super.setErrorMessage(errorMessage);
        }
    }

    protected T generateModelValue() {
        T bean = this.createNewBean();
        try {
            this.binder.writeBean(bean);
        }
        catch (ValidationException e) {
            return (T)this.getEmptyValue();
        }
        return bean;
    }

    protected void setPresentationValue(T value) {
        switch (this.initState) {
            case INITIAL: {
                this.initialValue = value;
                this.initState = InitState.INITIAL_VALUE;
                return;
            }
            case INITIAL_VALUE: {
                this.initialValue = value;
                return;
            }
        }
        T target = !Objects.equals(value, this.getEmptyValue()) ? value : this.createNewBean();
        this.binder.readBean(target);
    }

    private static enum InitState {
        INITIAL,
        INITIAL_VALUE,
        INITIALIZED;

    }
}

