/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.field;

import com.google.common.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.dellroad.stuff.vaadin24.field.AbstractFieldBuilder;

public interface FieldBuilderContext
extends Serializable {
    public AbstractFieldBuilder.BindingInfo getBindingInfo();

    default public Method getMethod() {
        return this.getBindingInfo().getMethod();
    }

    public Class<?> getBeanType();

    default public Class<?> inferDataModelType() {
        Class<?> returnType = this.getMethod().getReturnType();
        Type modelType = this.getMethod().getGenericReturnType();
        if (Collection.class.isAssignableFrom(returnType)) {
            try {
                modelType = ((ParameterizedType)modelType).getActualTypeArguments()[0];
            }
            catch (ArrayIndexOutOfBoundsException | ClassCastException e) {
                throw new IllegalArgumentException("can't determine collection element type from return type of method " + this.getMethod() + " in the context of " + this.getBeanType(), e);
            }
        }
        return TypeToken.of(this.getBeanType()).resolveType(modelType).getRawType();
    }
}

