/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.field;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import org.dellroad.stuff.vaadin24.field.AbstractFieldBuilder;
import org.dellroad.stuff.vaadin24.field.BinderCustomField;
import org.dellroad.stuff.vaadin24.field.FieldBuilder;
import org.dellroad.stuff.vaadin24.field.FieldComponent;

public class FieldBuilderCustomField<T>
extends BinderCustomField<T> {
    protected AbstractFieldBuilder<?, T> fieldBuilder;

    public FieldBuilderCustomField(Class<T> modelType) {
        super(modelType);
    }

    @Override
    protected void createAndBindFields() {
        this.fieldBuilder = this.createFieldBuilder();
        this.fieldBuilder.bindFields(this.binder);
    }

    protected AbstractFieldBuilder<?, T> createFieldBuilder() {
        return new FieldBuilder(this.modelType);
    }

    @Override
    protected void layoutComponents() {
        HorizontalLayout layout = new HorizontalLayout();
        this.add(new Component[]{layout});
        this.fieldBuilder.getFieldComponents().values().stream().map(FieldComponent::getComponent).forEach(xva$0 -> layout.add(new Component[]{xva$0}));
    }

    protected AbstractField<?, ?> getField(String name) {
        FieldComponent<?> fieldComponent = this.getFieldComponent(name);
        try {
            return (AbstractField)fieldComponent.getField();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("not an AbstractField: " + name);
        }
    }

    protected FieldComponent<?> getFieldComponent(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        FieldComponent<?> fieldComponent = this.fieldBuilder.getFieldComponents().get(name);
        if (fieldComponent == null) {
            throw new IllegalArgumentException("no such field: " + name);
        }
        return fieldComponent;
    }
}

