/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.field;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import java.io.Serializable;

public class FieldComponent<V>
implements Serializable {
    private static final long serialVersionUID = -4773664300675624288L;
    private final HasValue<?, V> field;
    private final Component component;

    public FieldComponent(HasValue<?, V> field, Component component) {
        if (field == null) {
            throw new IllegalArgumentException("null field");
        }
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        this.field = field;
        this.component = component;
    }

    public FieldComponent(AbstractField<?, V> field) {
        this((HasValue<?, V>)field, (Component)field);
    }

    public HasValue<?, V> getField() {
        return this.field;
    }

    public Component getComponent() {
        return this.component;
    }

    public AbstractField<?, V> getAbstractField() {
        if (this.field instanceof AbstractField) {
            return (AbstractField)this.field;
        }
        throw new IllegalArgumentException(this.field.getClass() + " is not a subtype of AbstractField");
    }

    public String toString() {
        return String.format("%s[field=%s%s]", this.getClass().getSimpleName(), this.getField(), this.getComponent() != this.getField() ? ",component=" + this.getComponent() : "");
    }
}

