/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.field;

import com.google.common.base.Preconditions;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasValidation;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValueContext;
import java.io.Serializable;
import org.dellroad.stuff.vaadin24.field.ValidatingField;

public class NullableField<T>
extends CustomField<T>
implements ValidatingField<AbstractField.ComponentValueChangeEvent<CustomField<T>, T>, T> {
    public static final String DEFAULT_ENABLED_BUT_NULL_ERROR = "Required value";
    protected final HasValue<?, T> innerField;
    protected final HasValue<?, Boolean> enabledField;
    protected final Component component;
    private boolean resetOnDisable = true;
    private boolean displayErrorMessages = true;

    public NullableField(AbstractField<?, T> innerField, String checkboxLabel) {
        this(innerField, (HasValue<?, Boolean>)new Checkbox(checkboxLabel));
    }

    public NullableField(AbstractField<?, T> innerField, HasValue<?, Boolean> enabledField) {
        this((HasValue<?, T>)innerField, (Component)innerField, enabledField);
    }

    public NullableField(HasValue<?, T> innerField, Component component, HasValue<?, Boolean> enabledField) {
        Preconditions.checkArgument((innerField != null ? 1 : 0) != 0, (Object)"null innerField");
        Preconditions.checkArgument((component != null ? 1 : 0) != 0, (Object)"null component");
        Preconditions.checkArgument((enabledField != null ? 1 : 0) != 0, (Object)"null enabledField");
        this.innerField = innerField;
        this.enabledField = enabledField;
        this.component = component;
        this.buildLayout();
        this.setComponentEnabled((Boolean)this.enabledField.getValue());
        this.enabledField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.handleEnabledFieldChange((Boolean)e.getValue()));
        this.innerField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.updateValue());
    }

    public HasValue<?, T> getInnerField() {
        return this.innerField;
    }

    public HasValue<?, Boolean> getEnabledField() {
        return this.enabledField;
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean isResetOnDisable() {
        return this.resetOnDisable;
    }

    public void setResetOnDisable(boolean resetOnDisable) {
        if (this.resetOnDisable == resetOnDisable) {
            return;
        }
        this.resetOnDisable = resetOnDisable;
        if (this.resetOnDisable && !((Boolean)this.enabledField.getValue()).booleanValue()) {
            this.innerField.setValue(this.innerField.getEmptyValue());
        }
    }

    public boolean isDisplayErrorMessages() {
        return this.displayErrorMessages;
    }

    public void setDisplayErrorMessages(boolean displayErrorMessages) {
        this.displayErrorMessages = displayErrorMessages;
    }

    public void setErrorMessage(String errorMessage) {
        if (this.isDisplayErrorMessages()) {
            super.setErrorMessage(errorMessage);
        }
    }

    @Override
    public ValidationResult validate(T value, ValueContext ctx) {
        boolean enabled = (Boolean)this.enabledField.getValue();
        if (value == null) {
            if (enabled) {
                return this.enabledButNullValidationResult();
            }
        } else if (this.innerField instanceof ValidatingField) {
            return ((ValidatingField)this.innerField).validate(value, ctx);
        }
        return ValidationResult.ok();
    }

    protected void handleEnabledFieldChange(boolean enabled) {
        if (enabled) {
            this.setComponentEnabled(true);
        } else {
            if (this.resetOnDisable) {
                this.innerField.setValue(this.innerField.getEmptyValue());
            }
            if (this.component instanceof HasValidation) {
                ((HasValidation)this.component).setErrorMessage(null);
                ((HasValidation)this.component).setInvalid(false);
            }
            this.setComponentEnabled(false);
        }
        this.updateValue();
    }

    protected ValidationResult enabledButNullValidationResult() {
        return ValidationResult.error((String)DEFAULT_ENABLED_BUT_NULL_ERROR);
    }

    protected void buildLayout() {
        HorizontalLayout layout = new HorizontalLayout();
        layout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.BASELINE);
        if (this.enabledField instanceof Component) {
            layout.add(new Component[]{(Component)this.enabledField});
        }
        layout.add(new Component[]{this.component});
        this.add(new Component[]{layout});
    }

    protected void setComponentEnabled(boolean enabled) {
        if (this.component instanceof HasEnabled) {
            ((HasEnabled)this.component).setEnabled(enabled);
        }
    }

    protected T generateModelValue() {
        return (T)((Boolean)this.enabledField.getValue() != false ? this.innerField.getValue() : null);
    }

    protected void setPresentationValue(T value) {
        boolean enabled = value != null;
        this.enabledField.setValue((Object)enabled);
        if (enabled) {
            this.innerField.setValue(value);
        }
    }
}

