/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.contextmenu.HasMenuItems;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.HeaderRow;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.shared.util.SharedUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dellroad.stuff.java.AnnotationUtil;
import org.dellroad.stuff.java.MethodAnnotationScanner;
import org.dellroad.stuff.java.ReflectUtil;
import org.dellroad.stuff.java.ThreadLocalHolder;
import org.dellroad.stuff.vaadin24.grid.GridColumn;
import org.dellroad.stuff.vaadin24.util.SelfRenderer;

public class GridColumnScanner<T> {
    private static final ThreadLocalHolder<Grid<?>> CURRENT_GRID = new ThreadLocalHolder();
    private final Class<T> type;
    private final LinkedHashMap<String, MethodAnnotationScanner.MethodInfo> columnMap = new LinkedHashMap();

    public GridColumnScanner(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("null type");
        }
        this.type = type;
        Set gridColumnMethods = new MethodAnnotationScanner(this.type, GridColumn.class).findAnnotatedMethods();
        Comparator<Method> methodComparator = Comparator.comparing(Method::getDeclaringClass, ReflectUtil.getClassComparator());
        HashMap<String, MethodAnnotationScanner.MethodInfo> unorderedColumnMap = new HashMap<String, MethodAnnotationScanner.MethodInfo>();
        for (MethodAnnotationScanner.MethodInfo methodInfo : gridColumnMethods) {
            String columnKey = this.determineColumnKey(methodInfo);
            MethodAnnotationScanner.MethodInfo previousInfo = unorderedColumnMap.putIfAbsent(columnKey, methodInfo);
            if (previousInfo == null) continue;
            int diff = methodComparator.compare(previousInfo.getMethod(), methodInfo.getMethod());
            if (diff > 0) {
                unorderedColumnMap.put(columnKey, methodInfo);
                continue;
            }
            if (diff != 0) continue;
            throw new IllegalArgumentException("duplicate @" + GridColumn.class.getSimpleName() + " declaration for column key `" + columnKey + "' on method " + previousInfo.getMethod() + " and on method " + methodInfo.getMethod());
        }
        unorderedColumnMap.entrySet().stream().sorted(Comparator.comparingDouble(entry -> ((GridColumn)((MethodAnnotationScanner.MethodInfo)entry.getValue()).getAnnotation()).order()).thenComparing(Map.Entry::getKey)).forEach(entry -> this.columnMap.put((String)entry.getKey(), (MethodAnnotationScanner.MethodInfo)entry.getValue()));
    }

    public GridColumnScanner(GridColumnScanner<T> original) {
        if (original == null) {
            throw new IllegalArgumentException("null original");
        }
        this.type = original.type;
        this.columnMap.putAll(original.columnMap);
    }

    public Class<T> getType() {
        return this.type;
    }

    public Map<String, MethodAnnotationScanner.MethodInfo> getColumnMap() {
        return this.columnMap;
    }

    public Grid<T> buildGrid() {
        Grid grid = new Grid(this.type, false);
        this.addColumnsTo(grid);
        return grid;
    }

    public void addColumnsTo(Grid<?> grid) {
        CURRENT_GRID.invoke(grid, () -> this.addColumnsTo2(grid));
    }

    private <S> void addColumnsTo2(Grid<S> grid) {
        if (grid == null) {
            throw new IllegalArgumentException("null grid");
        }
        LinkedHashMap existingColumnMap = grid.getColumns().stream().collect(Collectors.toMap(Grid.Column::getKey, c -> c, (c1, c2) -> {
            throw new RuntimeException("internal error");
        }, LinkedHashMap::new));
        GridColumn defaults = GridColumnScanner.getDefaults();
        LinkedHashMap<String, List> columnGroups = new LinkedHashMap<String, List>();
        this.columnMap.forEach((columnKey, methodInfo) -> {
            if (existingColumnMap.remove(columnKey) != null) {
                grid.removeColumnByKey(columnKey);
            }
            Method method = methodInfo.getMethod();
            GridColumn annotation = (GridColumn)methodInfo.getAnnotation();
            Class<?> requiredBeanType = method.getDeclaringClass();
            ValueProvider & Serializable valueProvider = (ValueProvider & Serializable)bean -> Optional.ofNullable(bean).filter(requiredBeanType::isInstance).map(obj -> ReflectUtil.invoke((Method)method, (Object)obj, (Object[])new Object[0])).orElse(null);
            boolean selfRendering = Component.class.isAssignableFrom(method.getReturnType());
            Grid.Column column = GridColumnScanner.addColumn(grid, columnKey, annotation, "method " + method, valueProvider, selfRendering, defaults);
            columnGroups.computeIfAbsent(annotation.columnGroup(), columnGroup -> new ArrayList()).add(column);
        });
        if (columnGroups.size() > 1 || columnGroups.size() == 1 && !((String)columnGroups.keySet().iterator().next()).isEmpty()) {
            HeaderRow headerRow = grid.prependHeaderRow();
            columnGroups.forEach((name, columns) -> headerRow.join(columns.toArray(new Grid.Column[0])).setText(name));
        }
        List columnList = Stream.concat(existingColumnMap.values().stream(), columnGroups.values().stream().flatMap(Collection::stream)).collect(Collectors.toList());
        grid.setColumnOrder(columnList);
    }

    public boolean addVisbilityMenuItems(Grid<?> grid, HasMenuItems menu) {
        if (grid == null) {
            throw new IllegalArgumentException("null grid");
        }
        if (menu == null) {
            throw new IllegalArgumentException("null menu");
        }
        AtomicBoolean menuItemsAdded = new AtomicBoolean();
        this.columnMap.forEach((columnKey, methodInfo) -> {
            GridColumn annotation = (GridColumn)methodInfo.getAnnotation();
            if (!annotation.visibilityMenu()) {
                return;
            }
            Grid.Column column = grid.getColumnByKey(columnKey);
            if (column == null) {
                return;
            }
            String menuLabel = !annotation.header().isEmpty() ? annotation.header() : SharedUtil.camelCaseToHumanFriendly((String)annotation.key());
            MenuItem menuItem = menu.addItem(menuLabel, (ComponentEventListener & Serializable)e -> column.setVisible(((MenuItem)e.getSource()).isChecked()));
            menuItem.setCheckable(true);
            menuItem.setChecked(column.isVisible());
            menuItemsAdded.set(true);
        });
        return menuItemsAdded.get();
    }

    public static <T> Grid.Column<T> addColumn(Grid<T> grid, String key, GridColumn annotation, String description, ValueProvider<T, ?> valueProvider, boolean selfRendering) {
        return (Grid.Column)CURRENT_GRID.invoke(grid, () -> GridColumnScanner.addColumn(grid, key, annotation, description, valueProvider, selfRendering, GridColumnScanner.getDefaults()));
    }

    public static Grid<?> currentGrid() {
        return (Grid)CURRENT_GRID.require();
    }

    private static <T> Grid.Column<T> addColumn(Grid<T> grid, String key, GridColumn annotation, String description, ValueProvider<T, ?> valueProvider, boolean selfRendering, GridColumn defaults) {
        class ErrorWrapper<T>
        implements Supplier<T> {
            private final Supplier<T> supplier;
            final /* synthetic */ String val$description;

            ErrorWrapper(Supplier<T> supplier2) {
                this.val$description = supplier2;
                this.supplier = supplier;
            }

            @Override
            public T get() {
                try {
                    return this.supplier.get();
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("error in @" + GridColumn.class.getSimpleName() + " annotation for " + this.val$description, e);
                }
            }
        }
        Grid.Column column;
        if (grid == null) {
            throw new IllegalArgumentException("null grid");
        }
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("null annotation");
        }
        if (valueProvider == null) {
            throw new IllegalArgumentException("null valueProvider");
        }
        if (defaults == null) {
            throw new IllegalArgumentException("null defaults");
        }
        Renderer renderer = null;
        if (!annotation.renderer().equals(defaults.renderer())) {
            renderer = (Renderer)new ErrorWrapper(() -> {
                Object[] constructorParams;
                Constructor<? extends Renderer> constructor;
                try {
                    constructor = annotation.renderer().getConstructor(ValueProvider.class);
                    constructorParams = new Object[]{valueProvider};
                }
                catch (Exception e) {
                    try {
                        constructor = annotation.renderer().getConstructor(new Class[0]);
                        constructorParams = new Object[]{};
                    }
                    catch (Exception e2) {
                        throw new RuntimeException("cannot instantiate " + annotation.renderer() + " because no default constructor or constructor taking ValueProvider is found", e);
                    }
                }
                return (Renderer)ReflectUtil.instantiate(constructor, (Object[])constructorParams);
            }, description).get();
        } else if (selfRendering) {
            renderer = new SelfRenderer(valueProvider);
        }
        if (grid instanceof TreeGrid && annotation.hierarchyColumn()) {
            TreeGrid treeGrid = (TreeGrid)grid;
            if (renderer != null) {
                if (!(renderer instanceof ComponentRenderer)) {
                    throw new RuntimeException("non-default renderer type " + renderer.getClass().getName() + " specified for " + description + " does not subclass " + ComponentRenderer.class.getName() + ", which is required when configuring a TreeGrid with hierarchyColumn() = true");
                }
                column = treeGrid.addComponentHierarchyColumn(arg_0 -> ((ComponentRenderer)((ComponentRenderer)renderer)).createComponent(arg_0));
            } else {
                column = treeGrid.addHierarchyColumn(valueProvider);
            }
        } else {
            column = renderer != null ? grid.addColumn(renderer) : grid.addColumn(valueProvider);
        }
        HashSet<String> autoProperties = new HashSet<String>(Arrays.asList("autoWidth", "classNameGenerator", "comparator", "flexGrow", "footer", "frozen", "header", "id", "resizable", "sortOrderProvider", "sortable", "textAlign", "visible", "width"));
        AnnotationUtil.applyAnnotationValues((Object)column, (String)"set", (Annotation)annotation, (Annotation)defaults, (method, name) -> autoProperties.contains(name) ? name : null, type -> new ErrorWrapper(() -> ReflectUtil.instantiate((Class)type), description).get());
        column.setKey(key);
        if (!annotation.valueProviderComparator().equals(defaults.valueProviderComparator())) {
            ValueProvider keyExtractor = (ValueProvider)new ErrorWrapper(() -> (ValueProvider)ReflectUtil.instantiate(annotation.valueProviderComparator()), description).get();
            column.setComparator(keyExtractor);
        }
        if (!annotation.editorComponent().equals(defaults.editorComponent())) {
            SerializableFunction componentCallback = (SerializableFunction)new ErrorWrapper(() -> (SerializableFunction)ReflectUtil.instantiate(annotation.editorComponent()), description).get();
            column.setEditorComponent(componentCallback);
        }
        if (annotation.sortProperties().length > 0) {
            column.setSortProperty(annotation.sortProperties());
        }
        return column;
    }

    @GridColumn
    private static GridColumn getDefaults() {
        return (GridColumn)AnnotationUtil.getAnnotation(GridColumn.class, GridColumnScanner.class, (String)"getDefaults", (Class[])new Class[0]);
    }

    protected String determineColumnKey(MethodAnnotationScanner.MethodInfo methodInfo) {
        if (!((GridColumn)methodInfo.getAnnotation()).key().isEmpty()) {
            return ((GridColumn)methodInfo.getAnnotation()).key();
        }
        return Optional.ofNullable(methodInfo.getMethodPropertyName()).orElseThrow(() -> new IllegalArgumentException("can't infer column key name from non-bean method " + methodInfo.getMethod()));
    }
}

