/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.util;

import com.google.common.base.Preconditions;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.dellroad.stuff.vaadin24.util.AsyncTask;
import org.dellroad.stuff.vaadin24.util.AsyncTaskStatusChangeEvent;
import org.dellroad.stuff.vaadin24.util.AsyncTaskStatusChangeListener;
import org.dellroad.stuff.vaadin24.util.VaadinUtil;
import org.slf4j.LoggerFactory;

public class AsyncTaskManager<R> {
    protected final VaadinSession session = VaadinUtil.getCurrentSession();
    private final HashSet<AsyncTaskStatusChangeListener<R>> listeners = new HashSet();
    private final AtomicLong lastTaskId = new AtomicLong();
    private Function<? super Runnable, ? extends Future<?>> executor;
    private BiConsumer<? super Long, ? super R> resultConsumer;
    private Future<?> currentFuture;
    private long currentId;

    public AsyncTaskManager() {
    }

    public AsyncTaskManager(Function<? super Runnable, ? extends Future<?>> executor) {
        this.setAsyncExecutor(executor);
    }

    public VaadinSession getVaadinSession() {
        return this.session;
    }

    public void setAsyncExecutor(Function<? super Runnable, ? extends Future<?>> executor) {
        this.executor = executor;
    }

    public void setResultConsumer(BiConsumer<? super Long, ? super R> resultConsumer) {
        this.resultConsumer = resultConsumer;
    }

    public long startTask(AsyncTask<? extends R> task) {
        Preconditions.checkArgument((task != null ? 1 : 0) != 0, (Object)"null task");
        VaadinUtil.assertCurrentSession(this.session);
        Preconditions.checkState((this.executor != null ? 1 : 0) != 0, (Object)"no executor");
        this.cancelTask();
        long id = this.nextTaskId();
        Preconditions.checkArgument((id != 0L ? 1 : 0) != 0, (Object)"invalid task ID");
        this.notifyListeners(new AsyncTaskStatusChangeEvent<Object>(this, id, 0, null, null));
        this.currentFuture = this.executor.apply(() -> this.invokeTask(id, task));
        this.currentId = id;
        return id;
    }

    public boolean isBusy() {
        VaadinUtil.assertCurrentSession(this.session);
        return this.currentId != 0L;
    }

    public long getCurrentTaskId() {
        VaadinUtil.assertCurrentSession(this.session);
        return this.currentId;
    }

    public long cancelTask() {
        VaadinUtil.assertCurrentSession(this.session);
        long id = this.currentId;
        if (id == 0L) {
            return 0L;
        }
        this.notifyListeners(new AsyncTaskStatusChangeEvent<Object>(this, id, 3, null, null));
        this.currentFuture.cancel(true);
        this.currentFuture = null;
        this.currentId = 0L;
        return id;
    }

    public Registration addAsyncTaskStatusChangeListener(AsyncTaskStatusChangeListener<R> listener) {
        VaadinUtil.assertCurrentSession(this.session);
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"null listener");
        return Registration.addAndRemove(this.listeners, listener);
    }

    protected long nextTaskId() {
        long nextTaskId;
        while ((nextTaskId = this.lastTaskId.incrementAndGet()) == 0L) {
        }
        return nextTaskId;
    }

    protected void invokeTask(long id, AsyncTask<? extends R> task) {
        Preconditions.checkArgument((id != 0L ? 1 : 0) != 0, (Object)"zero id");
        Preconditions.checkArgument((task != null ? 1 : 0) != 0, (Object)"null task");
        VaadinUtil.assertNotSession(this.session);
        Object result = null;
        Throwable exception = null;
        try {
            result = task.perform(id);
        }
        catch (InterruptedException e) {
            exception = e;
        }
        catch (Throwable t) {
            this.handleTaskException(id, t);
            exception = t;
        }
        Object result2 = result;
        InterruptedException exception2 = exception;
        VaadinUtil.accessSession(this.session, () -> this.reportTask(id, result2, exception2));
    }

    protected boolean reportTask(long id, R result, Throwable exception) {
        VaadinUtil.assertCurrentSession(this.session);
        Preconditions.checkArgument((id != 0L ? 1 : 0) != 0, (Object)"zero id");
        Preconditions.checkArgument((exception != null || result != null ? 1 : 0) != 0, (Object)"result and exception both given");
        if (id != this.currentId) {
            return false;
        }
        this.currentFuture = null;
        this.currentId = 0L;
        int status = exception instanceof InterruptedException ? 3 : (exception != null ? 4 : 1);
        AsyncTaskStatusChangeEvent<R> event = new AsyncTaskStatusChangeEvent<R>(this, id, status, result, exception);
        this.notifyListeners(event);
        if (exception == null) {
            this.handleTaskResult(id, result);
        }
        return true;
    }

    protected void notifyListeners(AsyncTaskStatusChangeEvent<R> event) {
        Preconditions.checkArgument((event != null ? 1 : 0) != 0, (Object)"null event");
        VaadinUtil.assertCurrentSession(this.session);
        ArrayList recipients = new ArrayList(this.listeners);
        VaadinUtil.accessSession(this.session, () -> recipients.stream().forEach(listener -> listener.onTaskStatusChange(event)));
    }

    protected void handleTaskResult(long id, R result) {
        VaadinUtil.assertCurrentSession(this.session);
        if (this.resultConsumer != null) {
            this.resultConsumer.accept(id, result);
        }
    }

    protected void handleTaskException(long id, Throwable t) {
        LoggerFactory.getLogger(this.getClass()).error("exception from async task #" + id, t);
    }
}

