/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.util;

import com.google.common.base.Preconditions;
import java.util.EventObject;
import org.dellroad.stuff.vaadin24.util.AsyncTaskManager;

public class AsyncTaskStatusChangeEvent<R>
extends EventObject {
    public static final int STARTED = 0;
    public static final int COMPLETED = 1;
    public static final int CANCELED = 3;
    public static final int FAILED = 4;
    private final long id;
    private final int status;
    private final R result;
    private final Throwable exception;

    public AsyncTaskStatusChangeEvent(AsyncTaskManager<R> source, long id, int status, R result, Throwable exception) {
        super(source);
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"null source");
        Preconditions.checkArgument((id != 0L ? 1 : 0) != 0, (Object)"zero id");
        switch (status) {
            case 0: {
                Preconditions.checkArgument((result == null ? 1 : 0) != 0, (Object)"result must be null");
                Preconditions.checkArgument((exception == null ? 1 : 0) != 0, (Object)"exception must be null");
                break;
            }
            case 1: {
                Preconditions.checkArgument((exception == null ? 1 : 0) != 0, (Object)"exception must be null");
                break;
            }
            case 3: {
                Preconditions.checkArgument((result == null ? 1 : 0) != 0, (Object)"result must be null");
                break;
            }
            case 4: {
                Preconditions.checkArgument((result == null ? 1 : 0) != 0, (Object)"result must be null");
                Preconditions.checkArgument((exception != null ? 1 : 0) != 0, (Object)"exception must not be null");
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid status");
            }
        }
        this.id = id;
        this.status = status;
        this.result = result;
        this.exception = exception;
    }

    public long getTaskId() {
        return this.id;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public AsyncTaskManager<R> getSource() {
        return (AsyncTaskManager)super.getSource();
    }

    public R getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }
}

