/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.util;

import com.vaadin.flow.server.SessionDestroyListener;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import org.dellroad.stuff.vaadin24.util.VaadinUtil;
import org.slf4j.LoggerFactory;

public abstract class VaadinExternalListener<S> {
    private final S eventSource;
    private final VaadinSession session;
    private Registration sessionDestroyRegistration;

    protected VaadinExternalListener(S eventSource) {
        this(eventSource, VaadinUtil.getCurrentSession());
    }

    protected VaadinExternalListener(S eventSource, VaadinSession session) {
        if (eventSource == null) {
            throw new IllegalArgumentException("null eventSource");
        }
        if (session == null) {
            throw new IllegalArgumentException("null session");
        }
        this.eventSource = eventSource;
        this.session = session;
    }

    public synchronized void register() {
        if (this.sessionDestroyRegistration != null) {
            throw new IllegalStateException("already registered");
        }
        this.registerExternal(this.eventSource);
        this.sessionDestroyRegistration = this.session.getService().addSessionDestroyListener((SessionDestroyListener & Serializable)e -> {
            if (this.session.equals(e.getSession())) {
                this.unregister();
            }
        });
    }

    public synchronized void unregister() {
        if (this.sessionDestroyRegistration != null) {
            this.sessionDestroyRegistration.remove();
            this.sessionDestroyRegistration = null;
        }
        this.unregisterExternal(this.eventSource);
    }

    public final VaadinSession getSession() {
        return this.session;
    }

    public final S getEventSource() {
        return this.eventSource;
    }

    protected boolean handleEvent(Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException("null action");
        }
        return VaadinUtil.accessSession(this.session, () -> {
            try {
                action.run();
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        });
    }

    protected void handleException(RuntimeException e) {
        LoggerFactory.getLogger(this.getClass()).error("exception in asynchronous listener", (Throwable)e);
        throw e;
    }

    protected abstract void registerExternal(S var1);

    protected abstract void unregisterExternal(S var1);
}

