/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.util;

import com.google.common.base.Preconditions;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.UIDetachedException;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.VaadinSessionState;

public final class VaadinUtil {
    private VaadinUtil() {
    }

    public static void assertCurrentSession() {
        VaadinUtil.getCurrentSession();
    }

    public static void assertCurrentSession(VaadinSession session) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"null session");
        VaadinSession currentSession = VaadinUtil.getCurrentSession();
        if (currentSession != session) {
            throw new IllegalStateException("the VaadinSession associated with the current thread " + currentSession + " is not the same session as the given one " + session);
        }
    }

    public static VaadinSession getCurrentSession() {
        VaadinSession session = VaadinSession.getCurrent();
        Preconditions.checkState((session != null ? 1 : 0) != 0, (Object)"there is no VaadinSession associated with the current thread");
        Preconditions.checkState((boolean)session.hasLock(), (Object)"the VaadinSession associated with the current thread is not locked");
        return session;
    }

    public static boolean accessCurrentSession(Runnable action) {
        return VaadinUtil.accessSession(VaadinUtil.getCurrentSession(), action);
    }

    public static boolean accessSession(VaadinSession session, Runnable action) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"null session");
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"null action");
        if (!VaadinSessionState.OPEN.equals((Object)session.getState())) {
            return false;
        }
        session.access(action::run);
        return true;
    }

    public static void accessSessionSynchronously(VaadinSession session, Runnable action) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"null session");
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"null action");
        session.accessSynchronously(action::run);
    }

    public static void assertNoSession() {
        VaadinUtil.assertNotSession(null);
    }

    public static void assertNotSession(VaadinSession session) {
        VaadinSession currentSession = VaadinSession.getCurrent();
        Preconditions.checkState((currentSession == null || !currentSession.hasLock() || session != null && currentSession != session ? 1 : 0) != 0, (Object)"VaadinSession is locked");
    }

    public static VaadinRequest getCurrentRequest() {
        VaadinRequest request = VaadinRequest.getCurrent();
        Preconditions.checkState((request != null ? 1 : 0) != 0, (Object)"there is no VaadinRequest associated with the current thread");
        return request;
    }

    public static UI getCurrentUI() {
        UI ui = UI.getCurrent();
        Preconditions.checkState((ui != null ? 1 : 0) != 0, (Object)"there is no UI associated with the current thread");
        return ui;
    }

    public static boolean accessUI(Runnable action) {
        UI ui = UI.getCurrent();
        Preconditions.checkState((ui != null ? 1 : 0) != 0, (Object)"there is no UI associated with the current thread");
        return VaadinUtil.accessUI(ui, action);
    }

    public static boolean accessUI(UI ui, Runnable action) {
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"null action");
        if (ui == null) {
            return false;
        }
        try {
            ui.access(action::run);
        }
        catch (UIDetachedException e) {
            return false;
        }
        return true;
    }

    public static boolean accessUISynchronously(UI ui, Runnable action) {
        Preconditions.checkArgument((action != null ? 1 : 0) != 0, (Object)"null action");
        if (ui == null) {
            return false;
        }
        try {
            ui.accessSynchronously(action::run);
        }
        catch (UIDetachedException e) {
            return false;
        }
        return true;
    }

    public static Page getCurrentPage() {
        Page page = VaadinUtil.getCurrentUI().getPage();
        Preconditions.checkState((page != null ? 1 : 0) != 0, (Object)"there is no Page associated with the current UI");
        return page;
    }
}

