/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin24.util;

import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.validator.BeanValidator;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.lang.annotation.ElementType;
import java.util.Locale;
import java.util.Optional;

public class WholeBeanValidator
implements com.vaadin.flow.data.binder.Validator<Object> {
    protected final Class<?> beanType;
    private Class<?>[] groups;
    private ValidatorFactory validatorFactory;

    public WholeBeanValidator(Class<?> beanType) {
        this.beanType = beanType;
    }

    public void setValidationGroups(Class<?>[] groups) {
        this.groups = groups != null ? groups : new Class[]{};
    }

    public void setValidatorFactory(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    public ValidationResult apply(Object bean, ValueContext valueContext) {
        Class[] groupsArray = this.groups != null ? this.groups : new Class[]{};
        Locale locale = valueContext.getLocale().orElse(Locale.getDefault());
        WorkaroundBeanValidator beanValidator = new WorkaroundBeanValidator(this.beanType, this.validatorFactory);
        return beanValidator.getValidatorFactory().usingContext().traversableResolver((TraversableResolver)new NeverTraversableResolver()).getValidator().validate(bean, groupsArray).stream().map(violation -> ValidationResult.error((String)beanValidator.getMessage((ConstraintViolation<?>)violation, locale))).findFirst().orElseGet(ValidationResult::ok);
    }

    static class WorkaroundBeanValidator
    extends BeanValidator {
        private final ValidatorFactory validatorFactory;

        WorkaroundBeanValidator(Class<?> beanType, ValidatorFactory validatorFactory) {
            super(beanType, "ignored");
            this.validatorFactory = validatorFactory;
        }

        public ValidatorFactory getValidatorFactory() {
            return Optional.ofNullable(this.validatorFactory).orElseGet(() -> BeanValidator.getJavaxBeanValidatorFactory());
        }

        public Validator getJavaxBeanValidator() {
            return this.getValidatorFactory().getValidator();
        }

        public String getMessage(ConstraintViolation<?> violation, Locale locale) {
            return this.getValidatorFactory().getMessageInterpolator().interpolate(violation.getMessageTemplate(), this.createContext(violation), locale);
        }
    }

    private static class NeverTraversableResolver
    implements TraversableResolver {
        private NeverTraversableResolver() {
        }

        public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return false;
        }

        public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return false;
        }
    }
}

