/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.AbstractContainer;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.dellroad.stuff.vaadin7.BackedItem;
import org.dellroad.stuff.vaadin7.Connectable;
import org.dellroad.stuff.vaadin7.InvalidQueryListException;
import org.dellroad.stuff.vaadin7.PropertyDef;
import org.dellroad.stuff.vaadin7.PropertyExtractor;
import org.dellroad.stuff.vaadin7.ProvidesPropertyScanner;
import org.dellroad.stuff.vaadin7.QueryList;
import org.dellroad.stuff.vaadin7.SimpleItem;

public abstract class AbstractQueryContainer<T>
extends AbstractContainer
implements PropertyExtractor<T>,
Container.Ordered,
Container.Indexed,
Container.PropertySetChangeNotifier,
Container.ItemSetChangeNotifier,
Connectable {
    private final HashMap<String, PropertyDef<?>> propertyMap = new HashMap();
    private PropertyExtractor<? super T> propertyExtractor;
    private final HashMap<Integer, BackedItem<T>> itemMap = new HashMap();
    private QueryList<? extends T> queryList;
    private long totalSize = -1L;

    protected AbstractQueryContainer() {
        this((PropertyExtractor<T>)null);
    }

    protected AbstractQueryContainer(PropertyExtractor<? super T> propertyExtractor) {
        this(propertyExtractor, null);
    }

    protected AbstractQueryContainer(Collection<? extends PropertyDef<?>> propertyDefs) {
        this(null, propertyDefs);
    }

    protected AbstractQueryContainer(PropertyExtractor<? super T> propertyExtractor, Collection<? extends PropertyDef<?>> propertyDefs) {
        this.setPropertyExtractor(propertyExtractor);
        this.setProperties(propertyDefs);
    }

    protected AbstractQueryContainer(Class<? super T> type) {
        ProvidesPropertyScanner<T> propertyReader = new ProvidesPropertyScanner<T>(type);
        this.setPropertyExtractor(propertyReader.getPropertyExtractor());
        this.setProperties(propertyReader.getPropertyDefs());
    }

    public PropertyExtractor<? super T> getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor<? super T> propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    @Override
    public <V> V getPropertyValue(T obj, PropertyDef<V> propertyDef) {
        if (this.propertyExtractor == null) {
            throw new IllegalStateException("no PropertyExtractor is configured for this container");
        }
        return this.propertyExtractor.getPropertyValue(obj, propertyDef);
    }

    public void setProperties(Collection<? extends PropertyDef<?>> propertyDefs) {
        if (propertyDefs == null) {
            propertyDefs = Collections.emptySet();
        }
        this.propertyMap.clear();
        for (PropertyDef<?> propertyDef : propertyDefs) {
            if (this.propertyMap.put(propertyDef.getName(), propertyDef) == null) continue;
            throw new IllegalArgumentException("duplicate property name `" + propertyDef.getName() + "'");
        }
        this.fireContainerPropertySetChange();
    }

    public void reload() {
        this.invalidate();
        this.fireItemSetChange();
    }

    @Override
    public void connect() {
    }

    @Override
    public void disconnect() {
    }

    protected abstract QueryList<? extends T> query(long var1);

    protected void invalidate() {
        this.queryList = null;
        this.itemMap.clear();
    }

    protected T getJavaObject(int index) {
        Exception exception;
        long currentSize;
        int attempt = 1;
        while (true) {
            currentSize = this.ensureList(index);
            if (index < 0 || (long)index >= currentSize) {
                return null;
            }
            try {
                return this.queryList.get(index);
            }
            catch (InvalidQueryListException e) {
                this.invalidate();
                if (attempt == 100) {
                    exception = e;
                    break;
                }
            }
            catch (IndexOutOfBoundsException e) {
                exception = e;
                break;
            }
            ++attempt;
        }
        throw new RuntimeException("query(" + index + ") returned a QueryList with size() = " + currentSize + " but QueryList.get(" + index + ") failed (attempt #" + attempt + ")", exception);
    }

    protected long ensureList(int hint) {
        if (this.queryList == null) {
            long newTotalSize;
            this.queryList = this.query(hint);
            long oldTotalSize = this.totalSize;
            this.totalSize = newTotalSize = this.queryList.size();
            if (oldTotalSize != -1L && newTotalSize != oldTotalSize) {
                this.handleSizeChange();
            }
        }
        return this.totalSize;
    }

    protected void handleSizeChange() {
    }

    protected BackedItem<T> createBackedItem(T object, Collection<PropertyDef<?>> propertyDefs, PropertyExtractor<? super T> propertyExtractor) {
        return new SimpleItem<T>(object, propertyDefs, propertyExtractor);
    }

    public BackedItem<T> getItem(Object itemId) {
        if (!(itemId instanceof Integer)) {
            return null;
        }
        int index = (Integer)itemId;
        T obj = this.getJavaObject(index);
        if (obj == null) {
            return null;
        }
        BackedItem<T> item = this.itemMap.get(index);
        if (item == null) {
            item = this.createBackedItem(obj, this.propertyMap.values(), this);
            this.itemMap.put(index, item);
        }
        return item;
    }

    public Collection<Integer> getItemIds() {
        return new IntList(this.size());
    }

    public Set<String> getContainerPropertyIds() {
        return Collections.unmodifiableSet(this.propertyMap.keySet());
    }

    public Property getContainerProperty(Object itemId, Object propertyId) {
        Item item = this.getItem(itemId);
        return item != null ? item.getItemProperty(propertyId) : null;
    }

    public Class<?> getType(Object propertyId) {
        PropertyDef<?> propertyDef = this.propertyMap.get(propertyId);
        return propertyDef != null ? propertyDef.getType() : null;
    }

    public int size() {
        return (int)this.ensureList(0);
    }

    public boolean containsId(Object itemId) {
        if (!(itemId instanceof Integer)) {
            return false;
        }
        int index = (Integer)itemId;
        return index >= 0 && (long)index < this.ensureList(index);
    }

    public Item addItem(Object itemId) {
        throw new UnsupportedOperationException();
    }

    public Item addItem() {
        throw new UnsupportedOperationException();
    }

    public boolean removeItem(Object itemId) {
        throw new UnsupportedOperationException();
    }

    public boolean addContainerProperty(Object propertyId, Class<?> type, Object defaultValue) {
        throw new UnsupportedOperationException();
    }

    public boolean removeContainerProperty(Object propertyId) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAllItems() {
        throw new UnsupportedOperationException();
    }

    public Object addItemAt(int index) {
        throw new UnsupportedOperationException();
    }

    public Item addItemAt(int index, Object newItemId) {
        throw new UnsupportedOperationException();
    }

    public Integer getIdByIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index < " + index);
        }
        long size = this.ensureList(index);
        if ((long)index >= size) {
            throw new IndexOutOfBoundsException("index=" + index + " but size=" + size);
        }
        return index;
    }

    public List<Integer> getItemIds(int startIndex, int numberOfItems) {
        if (numberOfItems < 0) {
            throw new IllegalArgumentException("numberOfItems < 0");
        }
        long size = this.ensureList(startIndex);
        if (startIndex < 0 || (long)startIndex > size) {
            throw new IndexOutOfBoundsException("startIndex=" + startIndex + " but size=" + size);
        }
        if ((long)(startIndex + numberOfItems) > size) {
            numberOfItems = (int)(size - (long)startIndex);
        }
        return new IntList(startIndex, numberOfItems);
    }

    public int indexOfId(Object itemId) {
        if (!(itemId instanceof Integer)) {
            return -1;
        }
        int index = (Integer)itemId;
        if (index < 0 || (long)index >= this.ensureList(index)) {
            return -1;
        }
        return index;
    }

    public Integer nextItemId(Object itemId) {
        if (!(itemId instanceof Integer)) {
            return null;
        }
        int index = (Integer)itemId;
        if (index < 0 || (long)(index + 1) >= this.ensureList(index)) {
            return null;
        }
        return index + 1;
    }

    public Integer prevItemId(Object itemId) {
        if (!(itemId instanceof Integer)) {
            return null;
        }
        int index = (Integer)itemId;
        if (index - 1 < 0 || (long)index >= this.ensureList(index)) {
            return null;
        }
        return index - 1;
    }

    public Integer firstItemId() {
        return this.ensureList(0) == 0L ? null : Integer.valueOf(0);
    }

    public Integer lastItemId() {
        long size = this.ensureList(0);
        return size == 0L ? null : Integer.valueOf((int)size - 1);
    }

    public boolean isFirstId(Object itemId) {
        if (!(itemId instanceof Integer)) {
            return false;
        }
        int index = (Integer)itemId;
        long size = this.ensureList(index);
        return size > 0L && index == 0;
    }

    public boolean isLastId(Object itemId) {
        if (!(itemId instanceof Integer)) {
            return false;
        }
        int index = (Integer)itemId;
        long size = this.ensureList(index);
        return size > 0L && (long)index == size - 1L;
    }

    public Item addItemAfter(Object previousItemId) {
        throw new UnsupportedOperationException();
    }

    public Item addItemAfter(Object previousItemId, Object newItemId) {
        throw new UnsupportedOperationException();
    }

    public void addListener(Container.PropertySetChangeListener listener) {
        super.addListener(listener);
    }

    public void addPropertySetChangeListener(Container.PropertySetChangeListener listener) {
        super.addPropertySetChangeListener(listener);
    }

    public void removeListener(Container.PropertySetChangeListener listener) {
        super.removeListener(listener);
    }

    public void removePropertySetChangeListener(Container.PropertySetChangeListener listener) {
        super.removePropertySetChangeListener(listener);
    }

    public void addListener(Container.ItemSetChangeListener listener) {
        super.addListener(listener);
    }

    public void addItemSetChangeListener(Container.ItemSetChangeListener listener) {
        super.addItemSetChangeListener(listener);
    }

    public void removeListener(Container.ItemSetChangeListener listener) {
        super.removeListener(listener);
    }

    public void removeItemSetChangeListener(Container.ItemSetChangeListener listener) {
        super.removeItemSetChangeListener(listener);
    }

    private static class IntList
    extends AbstractList<Integer> {
        private final int min;
        private final int size;

        IntList(int size) {
            this(0, size);
        }

        IntList(int min, int size) {
            if (size < 0) {
                throw new IllegalArgumentException("size < 0");
            }
            this.min = min;
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public Integer get(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return this.min + index;
        }
    }
}

