/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import com.vaadin.data.Property;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomField;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Notification;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.Upload;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobField
extends CustomField<byte[]>
implements Serializable,
Upload.Receiver,
Upload.StartedListener,
Upload.ProgressListener,
Upload.SucceededListener,
Upload.FailedListener {
    private static final long serialVersionUID = 7566102164730793008L;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Label descriptionLabel = new Label();
    private final HorizontalLayout layout = new HorizontalLayout();
    private transient ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final ProgressBar progressBar = new ProgressBar();
    private final Upload upload = new Upload();

    public BlobField() {
        this.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                BlobField.this.updateDisplay();
            }
        });
        this.addReadOnlyStatusChangeListener(new Property.ReadOnlyStatusChangeListener(){

            public void readOnlyStatusChange(Property.ReadOnlyStatusChangeEvent event) {
                BlobField.this.updateDisplay();
            }
        });
    }

    public void attach() {
        super.attach();
        this.updateDisplay();
    }

    public void detach() {
        super.detach();
        this.upload.interruptUpload();
    }

    public Upload getUpload() {
        return this.upload;
    }

    public Label getDescriptionLabel() {
        return this.descriptionLabel;
    }

    public Class<byte[]> getType() {
        return byte[].class;
    }

    protected Component initContent() {
        this.layout.setMargin(false);
        this.layout.setSpacing(true);
        this.descriptionLabel.setSizeUndefined();
        this.layout.addComponent((Component)this.descriptionLabel);
        this.layout.setComponentAlignment((Component)this.descriptionLabel, Alignment.MIDDLE_LEFT);
        this.layout.addComponent((Component)new Label("\u00a0\u00a0"));
        this.upload.setReceiver((Upload.Receiver)this);
        this.upload.addStartedListener((Upload.StartedListener)this);
        this.upload.addProgressListener((Upload.ProgressListener)this);
        this.upload.addSucceededListener((Upload.SucceededListener)this);
        this.upload.addFailedListener((Upload.FailedListener)this);
        this.upload.setImmediate(true);
        this.layout.addComponent((Component)this.upload);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setVisible(false);
        this.layout.addComponent((Component)this.progressBar);
        this.layout.setComponentAlignment((Component)this.progressBar, Alignment.MIDDLE_LEFT);
        this.layout.setExpandRatio((Component)this.progressBar, 1.0f);
        return this.layout;
    }

    protected void setInternalValue(byte[] value) {
        super.setInternalValue((Object)value);
        this.updateDisplay();
    }

    public OutputStream receiveUpload(String filename, String mimeType) {
        return this.buffer;
    }

    public void uploadStarted(Upload.StartedEvent event) {
        this.log.info("started upload of file `" + event.getFilename() + "'");
        this.progressBar.setValue(Float.valueOf(0.0f));
        this.progressBar.setVisible(true);
        this.updateDisplay();
    }

    public void updateProgress(long readBytes, long contentLength) {
        float fraction = (float)readBytes / (float)contentLength;
        fraction = Math.max(fraction, 0.0f);
        fraction = Math.min(fraction, 1.0f);
        fraction = (float)((int)(fraction * 64.0f)) / 64.0f;
        this.progressBar.setValue(Float.valueOf(fraction));
    }

    public void uploadSucceeded(Upload.SucceededEvent event) {
        byte[] data = this.buffer.toByteArray();
        this.log.info("finished upload of file `" + event.getFilename() + "' (" + data.length + " bytes)");
        this.buffer.reset();
        this.setValue(data);
        this.progressBar.setVisible(false);
        this.updateDisplay();
    }

    public void uploadFailed(Upload.FailedEvent event) {
        this.log.info("failed upload of file `" + event.getFilename() + "': " + event.getReason());
        this.progressBar.setVisible(false);
        this.updateDisplay();
        if (this.getUI() != null) {
            Notification notification = new Notification("Upload failed", "" + event.getReason(), Notification.Type.ERROR_MESSAGE);
            notification.setDelayMsec(3000);
            notification.show(this.getUI().getPage());
        }
    }

    protected void updateDisplay() {
        byte[] value = (byte[])this.getValue();
        this.descriptionLabel.setValue(value != null ? String.valueOf(value.length) + " bytes" : "Null");
        this.upload.setEnabled(!this.isReadOnly());
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        output.writeObject(this.buffer.toByteArray());
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.buffer = new ByteArrayOutputStream();
        this.buffer.write((byte[])input.readObject());
    }
}

