/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.dellroad.stuff.vaadin7.BackedItem;
import org.dellroad.stuff.vaadin7.BackedProperty;
import org.dellroad.stuff.vaadin7.PropertyDef;
import org.dellroad.stuff.vaadin7.PropertyExtractor;
import org.dellroad.stuff.vaadin7.ReadOnlyProperty;

public class SimpleItem<T>
implements BackedItem<T> {
    protected final T object;
    protected final PropertyExtractor<? super T> propertyExtractor;
    private final Object[] propertyList;

    public SimpleItem(T object, Collection<? extends PropertyDef<?>> propertyDefs, PropertyExtractor<? super T> propertyExtractor) {
        if (object == null) {
            throw new IllegalArgumentException("null object");
        }
        if (propertyExtractor == null) {
            throw new IllegalArgumentException("null propertyExtractor");
        }
        if (propertyDefs == null) {
            throw new IllegalArgumentException("null propertyDefs");
        }
        this.object = object;
        this.propertyExtractor = propertyExtractor;
        this.propertyList = propertyDefs.toArray();
    }

    @Override
    public T getObject() {
        return this.object;
    }

    public Property<?> getItemProperty(Object id) {
        int i = 0;
        while (i < this.propertyList.length) {
            Object value = this.propertyList[i];
            if (value instanceof PropertyDef) {
                PropertyDef propertyDef = (PropertyDef)value;
                if (propertyDef.getName().equals(id)) {
                    Property property;
                    this.propertyList[i] = property = this.createProperty(propertyDef);
                    return property;
                }
            } else if (value instanceof Property) {
                Property property = (Property)value;
                if (property.getPropertyDef().getName().equals(id)) {
                    return property;
                }
            } else {
                throw new RuntimeException("internal error: found " + value);
            }
            ++i;
        }
        return null;
    }

    public Set<String> getItemPropertyIds() {
        HashSet<String> names = new HashSet<String>(this.propertyList.length);
        int i = 0;
        while (i < this.propertyList.length) {
            Object value = this.propertyList[i];
            if (value instanceof PropertyDef) {
                PropertyDef propertyDef = (PropertyDef)value;
                names.add(propertyDef.getName());
            } else if (value instanceof Property) {
                Property property = (Property)value;
                names.add(property.getPropertyDef().getName());
            } else {
                throw new RuntimeException("internal error: found " + value);
            }
            ++i;
        }
        return names;
    }

    public boolean addItemProperty(Object id, com.vaadin.data.Property property) {
        throw new UnsupportedOperationException();
    }

    public boolean removeItemProperty(Object id) {
        throw new UnsupportedOperationException();
    }

    public void fireValueChange(String propertyName) {
        int i = 0;
        while (i < this.propertyList.length) {
            Property property;
            Object value = this.propertyList[i];
            if (value instanceof Property && (property = (Property)value).getPropertyDef().getName().equals(propertyName)) {
                property.fireValueChange();
                return;
            }
            ++i;
        }
    }

    public void fireValueChange() {
        int i = 0;
        while (i < this.propertyList.length) {
            Object value = this.propertyList[i];
            if (value instanceof Property) {
                Property property = (Property)value;
                property.fireValueChange();
            }
            ++i;
        }
    }

    protected <V> Property<V> createProperty(PropertyDef<V> propertyDef) {
        return new Property<V>(propertyDef);
    }

    public class Property<V>
    extends ReadOnlyProperty<V>
    implements BackedProperty<T, V> {
        private final PropertyDef<V> propertyDef;

        public Property(PropertyDef<V> propertyDef) {
            if (propertyDef == null) {
                throw new IllegalArgumentException("null propertyDef");
            }
            this.propertyDef = propertyDef;
        }

        public PropertyDef<V> getPropertyDef() {
            return this.propertyDef;
        }

        @Override
        public T getObject() {
            return SimpleItem.this.object;
        }

        public Class<V> getType() {
            return this.propertyDef.getType();
        }

        public V getValue() {
            return SimpleItem.this.propertyExtractor.getPropertyValue(SimpleItem.this.object, this.propertyDef);
        }
    }
}

