/*
 * Decompiled with CFR 0.152.
 */
package org.dellroad.stuff.vaadin7;

import java.util.Collection;
import java.util.HashMap;
import org.dellroad.stuff.vaadin7.AbstractSimpleContainer;
import org.dellroad.stuff.vaadin7.PropertyDef;
import org.dellroad.stuff.vaadin7.PropertyExtractor;

public abstract class SimpleKeyedContainer<I, T>
extends AbstractSimpleContainer<I, T> {
    private HashMap<I, T> objectMap = new HashMap(0);

    protected SimpleKeyedContainer() {
    }

    protected SimpleKeyedContainer(PropertyExtractor<? super T> propertyExtractor) {
        this(propertyExtractor, null);
    }

    protected SimpleKeyedContainer(Collection<? extends PropertyDef<?>> propertyDefs) {
        this(null, propertyDefs);
    }

    protected SimpleKeyedContainer(PropertyExtractor<? super T> propertyExtractor, Collection<? extends PropertyDef<?>> propertyDefs) {
        super(propertyExtractor, propertyDefs);
    }

    protected SimpleKeyedContainer(Class<? super T> type) {
        super(type);
    }

    @Override
    public T getJavaObject(Object itemId) {
        if (itemId == null) {
            return null;
        }
        return this.objectMap.get(itemId);
    }

    @Override
    public I getItemIdFor(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("null object");
        }
        I key = this.getKeyFor(obj);
        if (key == null) {
            throw new IllegalArgumentException("null key returned by getKeyFor() for object " + obj);
        }
        T candidate = this.objectMap.get(key);
        return (I)(obj.equals(candidate) ? key : null);
    }

    @Override
    public I getItemIdForSame(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("null object");
        }
        I key = this.getKeyFor(obj);
        if (key == null) {
            throw new RuntimeException("null key returned by getKeyFor() for object " + obj);
        }
        T candidate = this.objectMap.get(key);
        return (I)(obj == candidate ? key : null);
    }

    @Override
    protected void resetItemIds() {
        this.objectMap = new HashMap();
    }

    @Override
    protected final I generateItemId(T obj) {
        I key = this.getKeyFor(obj);
        if (key == null) {
            throw new RuntimeException("null key returned by getKeyFor() for object " + obj);
        }
        T previous = this.objectMap.put(key, obj);
        if (previous != null) {
            throw new RuntimeException("same key " + key + " used by two different objects " + previous + " and " + obj);
        }
        return key;
    }

    protected abstract I getKeyFor(T var1);
}

